﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Threading;
using System.Windows.Forms;

namespace EffectMaker.UIDialogs.MessageDialogs
{
    /// <summary>
    /// FE1世代のesetをアップデートしている間表示するダイアログです。
    /// </summary>
    public partial class AncientEsetUpdaterDialog : Form
    {
        /// <summary>
        /// アップデートメソッドです。
        /// </summary>
        Action updateMethod;

        /// <summary>
        /// ダイアログの表示が完了するまでスレッドを停止するためのフラグです。
        /// </summary>
        private AutoResetEvent activateFlag;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="message">メッセージ</param>
        /// <param name="caption">キャプション</param>
        /// <param name="method">アップデートメソッド</param>
        public AncientEsetUpdaterDialog(string message, string caption, Action method)
        {
            this.InitializeComponent();

            this.Text = caption;
            this.lblMessage.Text = message;
            this.updateMethod = method;

            this.activateFlag = new AutoResetEvent(false);
        }

        /// <summary>
        /// ダイアログを表示し、アップデート処理を行います。
        /// </summary>
        public void ShowAndRun()
        {
            // ダイアログの表示を非同期で行った場合、ダイアログのモーダル化が複雑になるので
            // アップデート処理の方を非同期で実行する
            Thread thread = new Thread(new ThreadStart(this.Run));
            thread.IsBackground = true;
            thread.Start();

            // ダイアログを表示
            this.ShowDialog();

            // 処理が完了したらダイアログは自動で閉じられる
        }

        /// <summary>
        /// ダイアログの表示が完了したときの処理を行います
        /// </summary>
        /// <param name="e">イベントの情報</param>
        protected override void OnActivated(EventArgs e)
        {
            base.OnActivated(e);

            // 表示完了フラグを立てる
            this.activateFlag.Set();
        }

        /// <summary>
        /// ダイアログ表示中に実行する処理です。
        /// </summary>
        private void Run()
        {
            // ダイアログの表示が完了するまで待機
            this.activateFlag.WaitOne();

            // アップデート処理を実行
            this.updateMethod();

            // ダイアログを閉じる
            this.Invoke(new MethodInvoker(this.Close));
        }
    }
}
