﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.UIDialogs.ExportDialog
{
    /// <summary>
    /// ドロップダウンボタンクラス。
    /// </summary>
    public sealed class DropDownButton : UIButton
    {
        /// <summary>
        /// ドロップダウンメニュー
        /// </summary>
        private UIContextMenuStrip dropDownMenu = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public DropDownButton()
        {
            this.DropDownMenu = new UIContextMenuStrip();
        }

        /// <summary>
        /// ドロップダウンメニュー。
        /// </summary>
        [DefaultValue(null)]
        [Description("クリック時に表示するコンテキストメニュー。")]
        public UIContextMenuStrip DropDownMenu
        {
            get
            {
                return this.dropDownMenu;
            }

            set
            {
                if (this.dropDownMenu != value)
                {
                    this.dropDownMenu = value;
                }
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        /// <param name="e">event</param>
        protected override void OnPaint(PaintEventArgs e)
        {
            // 基本描画処理を行なう必要があるので先に呼ぶ
            base.OnPaint(e);

            // ドロップダウンマーク
            Rectangle rectClient = this.ClientRectangle;
            Rectangle rectMark = new Rectangle(0, 0, 8, 4);
            rectMark.X = rectClient.Width - (rectMark.Width + 6);
            rectMark.Y = (rectClient.Height - rectMark.Height) / 2;
            {
                Pen pen = SystemPens.ControlText;
                if (!this.Enabled)
                {
                    pen = SystemPens.GrayText;
                }

                for (int i = 0; i < rectMark.Height; i++)
                {
                    e.Graphics.DrawLine(pen, rectMark.Left + i, rectMark.Top + i, (rectMark.Right - 1) - i, rectMark.Top + i);
                }
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        /// <param name="e">event</param>
        protected override void OnClick(EventArgs e)
        {
            // ドロップダウンメニュー表示
            if (this.dropDownMenu != null)
            {
                var loc = this.PointToScreen(new Point(0, 0));
                loc.X += 1;
                loc.Y += this.Height;
                this.dropDownMenu.Show(loc);
            }

            base.OnClick(e);
        }
    }
}
