﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Reflection;
using System.Xaml;
using System.Xaml.Schema;

namespace EffectMaker.UIControls.Xaml
{
    /// <summary>
    /// An extended XamlMember class that overrides the LookupInvoker
    /// method to provider a custom XamlMemberInvoker.
    /// </summary>
    public class PropertyXamlMember : XamlMember
    {
        /// <summary>
        /// Initializes the PropertyXamlMember instance.
        /// </summary>
        /// <param name="propertyInfo">The property that represent this XamlMember.</param>
        /// <param name="schemaContext">The current schema context
        /// provided by the XAML engine.</param>
        public PropertyXamlMember(PropertyInfo propertyInfo, XamlSchemaContext schemaContext)
            : base(propertyInfo, schemaContext)
        {
        }

        /// <summary>
        /// Provides a PropertyXamlMemberInvoker.
        /// </summary>
        /// <returns>Returns an instance of PropertyXamlMemberInvoker class.</returns>
        protected override XamlMemberInvoker LookupInvoker()
        {
            return new PropertyXamlMemberInvoker((PropertyInfo)UnderlyingMember, this);
        }

        /// <summary>
        /// Tells whether the lookup is unknwon or not.
        /// </summary>
        /// <returns>Always return false, as the lookup is known.</returns>
        protected override bool LookupIsUnknown()
        {
            return false;
        }
    }
}
