﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Windows.Media;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Layout;
using Color = System.Drawing.Color;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// UI用定数
    /// </summary>
    public static class UIConstants
    {
        /// <summary>
        /// ラベルカラー0色
        /// </summary>
        public static readonly Color LabelColorColor0 = Color.FromArgb(0xFF, 0xFF, 0xFF);

        /// <summary>
        /// ラベルカラー1色
        /// </summary>
        public static readonly Color LabelColorColor1 = Color.FromArgb(0xE8, 0xCE, 0xBE);

        /// <summary>
        /// ラベルカラー2色
        /// </summary>
        public static readonly Color LabelColorColor2 = Color.FromArgb(0xF2, 0xD7, 0xAE);

        /// <summary>
        /// ラベルカラー3色
        /// </summary>
        public static readonly Color LabelColorColor3 = Color.FromArgb(0xF2, 0xF0, 0xAE);

        /// <summary>
        /// ラベルカラー4色
        /// </summary>
        public static readonly Color LabelColorColor4 = Color.FromArgb(0xD1, 0xE2, 0xB4);

        /// <summary>
        /// ラベルカラー5色
        /// </summary>
        public static readonly Color LabelColorColor5 = Color.FromArgb(0xD0, 0xDB, 0xEC);

        /// <summary>
        /// ラベルカラー6色
        /// </summary>
        public static readonly Color LabelColorColor6 = Color.FromArgb(0xDB, 0xD2, 0xE5);

        /// <summary>
        /// ラベルカラー7色
        /// </summary>
        public static readonly Color LabelColorColor7 = Color.FromArgb(0xE0, 0xE0, 0xE0);

        /// <summary>
        /// ラベルカラー色
        /// </summary>
        public static readonly Color[] LabelColorColors =
        {
            LabelColorColor0,
            LabelColorColor1,
            LabelColorColor2,
            LabelColorColor3,
            LabelColorColor4,
            LabelColorColor5,
            LabelColorColor6,
            LabelColorColor7
        };

        /// <summary>
        /// The get index from rgb.
        /// </summary>
        /// <param name="color">
        /// The color.
        /// </param>
        /// <returns>
        /// The <see cref="int"/>.
        /// </returns>
        public static int GetIndexFromRgb(Color color)
        {
            for (int i = 0; i < LabelColorColors.Length; ++i)
            {
                // 3D Editorを通すと値がブレるっぽいので遊びを持たせる
                if (Math.Abs(color.R - LabelColorColors[i].R) < 3 &&
                    Math.Abs(color.G - LabelColorColors[i].G) < 3 &&
                    Math.Abs(color.B - LabelColorColors[i].B) < 3)
                {
                    return i;
                }
            }

            return 0;
        }
    }
}
