﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reflection;
using System.Windows.Markup;
using System.Xaml;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.Xaml;

namespace EffectMaker.UIControls.Resources
{
    /// <summary>
    /// 画像を取得するXAML用のクラス。
    /// </summary>
    public class Image : System.Windows.Markup.MarkupExtension
    {
        /// <summary>
        /// The error text returned when it is not possible to access to localized string.
        /// </summary>
        private const string ErrorText = "<ERROR>";

        /// <summary>
        /// Constructor.
        /// </summary>
        public Image()
        {
            this.StringId = string.Empty;
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="stringId">The string ID.</param>
        public Image(string stringId)
        {
            this.StringId = stringId;
        }

        /// <summary>
        /// Gets or sets a the string ID.
        /// </summary>
        public string StringId { get; set; }

        /// <summary>
        /// Get the value.
        /// </summary>
        /// <param name="serviceProvider">An instance of a IServiceProvider
        /// provided by the XAML engine.</param>
        /// <returns>Returns string.</returns>
        public override object ProvideValue(IServiceProvider serviceProvider)
        {
            var targetProvider =
                serviceProvider.GetService(typeof(IProvideValueTarget)) as IProvideValueTarget;

            if (targetProvider == null)
            {
                return ErrorText;
            }

            var targetObject = targetProvider.TargetObject;

            if (targetObject == null)
            {
                return ErrorText;
            }

            Assembly sourceAssembly = null;

            var xamlSchemaContextProvider = (IXamlSchemaContextProvider)serviceProvider.GetService(
                typeof(IXamlSchemaContextProvider));

            if (xamlSchemaContextProvider != null)
            {
                var context =
                    xamlSchemaContextProvider.SchemaContext as EffectMakerXamlSchemaContext;

                if (context != null)
                {
                    sourceAssembly = context.SourceAssembly;
                }
            }

            if (sourceAssembly == null)
            {
                sourceAssembly = targetObject.GetType().Assembly;
            }

            System.Drawing.Image img;

            if (ResourceUtility.GetImageValue(sourceAssembly, this.StringId, out img) == false)
            {
                img = null;
            }

            return img;
        }
    }
}
