﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Windows.Forms;
using System.Windows.Forms.Layout;

namespace EffectMaker.UIControls.Layout
{
    /// <summary>
    /// A panel with stacking layout capabilities.
    /// </summary>
    public class StackPanel : UILayoutPanel<StackLayoutEngine>
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        public StackPanel()
        {
            this.Margin = new Padding(0);

            // 本来はこちらで対処するのが正しいが、一部ページの表示が崩れるので
            // UIGroupBoxExでの暫定対処を採用
            // this.AutoSizeMode = AutoSizeMode.GrowAndShrink;
        }

        /// <summary>
        /// Gets or sets the orientation of the control.
        /// </summary>
        public Orientation Orientation
        {
            get
            {
                return this.InternalLayoutEngine.Orientation;
            }

            set
            {
                this.InternalLayoutEngine.Orientation = value;
            }
        }

        /// <summary>
        /// Produces a StackLayoutEngine instance.
        /// </summary>
        /// <returns>Returns a StackLayoutEngine instance.</returns>
        protected override StackLayoutEngine ProduceLayoutEngine()
        {
            return new StackLayoutEngine();
        }
    }
}
