﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.UIControls
{
#if DEBUG // For unit test purpose only

    /// <summary>
    /// An extended UIControl class with a change notification mecanism on TagEx property.
    /// </summary>
    public class FakeControl : UIControl
    {
        /// <summary>
        /// Backing field for the TagEx property.
        /// </summary>
        private object tagEx;

        /// <summary>
        /// Gets or sets a custom value.
        /// This property may raise a 'TagEx' change notification.
        /// </summary>
        public object TagEx
        {
            get { return this.tagEx; }
            set { LogicalTreeElementExtender.SetValue(ref this.tagEx, value); }
        }
    }

#endif // DEBUG
}
