﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using System.Diagnostics;
using EffectMaker.UIControls.DataBinding;

namespace EffectMaker.UIControls.EventArguments
{
    /// <summary>
    /// An extended PropertyChangedEventArgs class.
    /// Adds UpdateSourceTrigger property.
    /// </summary>
    public class PropertyChangedExEventArgs : PropertyChangedEventArgs
    {
        /// <summary>
        /// Initializes the PropertyChangedExEventArgs instance.
        /// </summary>
        /// <param name="propertyName">The name of the modified property.</param>
        /// <param name="updateType">The update type.</param>
        [DebuggerStepThrough]
        public PropertyChangedExEventArgs(
            string propertyName,
            BindingUpdateType updateType)
            : base(propertyName)
        {
            BindingUpdateType = updateType;
        }

        /// <summary>
        /// Gets the type of binding update.
        /// </summary>
        public BindingUpdateType BindingUpdateType { get; private set; }
    }
}
