﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using System.Windows.Forms;

namespace EffectMaker.UIControls.DataBinding
{
    /// <summary>
    /// An observable collection of Binder instance.
    /// </summary>
    public class BindingContainer : ObservableCollection<Binder>
    {
        /// <summary>
        /// Initializes the BindingCollection instance.
        /// </summary>
        /// <param name="relatedControl">The control on which the
        /// BindingContainer is attached.</param>
        public BindingContainer(ILogicalTreeElement relatedControl)
        {
            if (relatedControl == null)
            {
                throw new ArgumentNullException("relatedControl");
            }

            this.RelatedControl = relatedControl;
        }

        /// <summary>
        /// Gets the control on which this BindingContainer is attached.
        /// </summary>
        public ILogicalTreeElement RelatedControl { get; private set; }
    }
}
