﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Layout;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// +/-チェックボックス
    /// </summary>
    public partial class PlusMinusCheckBox : UIUserControl
    {
        /// <summary>
        /// UI画像: チェックOff, マウスアウト
        /// </summary>
        private static readonly Bitmap ImageOff     = Properties.Resources.Icon_Curve_PlusMinus_Off;

        /// <summary>
        /// UI画像: チェックOff, マウスオーバー
        /// </summary>
        private static readonly Bitmap ImageOffOver = Properties.Resources.Icon_Curve_PlusMinus_Off_Over;

        /// <summary>
        /// UI画像: チェックOn, マウスアウト
        /// </summary>
        private static readonly Bitmap ImageOn      = Properties.Resources.Icon_Curve_PlusMinus_On;

        /// <summary>
        /// UI画像: チェックOn, マウスオーバー
        /// </summary>
        private static readonly Bitmap ImageOnOver  = Properties.Resources.Icon_Curve_PlusMinus_On_Over;

        /// <summary>
        /// チェック状態
        /// </summary>
        private bool buttonChecked;

        /// <summary>
        /// ラベルの下に移動するためのベース
        /// </summary>
        private UIUserControl basePanel = null;

        /// <summary>
        /// ラベルの下に移動済みならtrue,そうでなければfalse.
        /// </summary>
        private bool moved = false;

        /// <summary>
        ///  コンストラクタ
        /// </summary>
        public PlusMinusCheckBox()
        {
            this.InitializeComponent();

            cbxButton.ImageAlign = ContentAlignment.MiddleRight;

            cbxButton.MouseDown  += (s, e) => cbxButton.Image = this.Checked ? ImageOnOver : ImageOffOver;
            cbxButton.MouseUp    += (s, e) => cbxButton.Image = this.Checked ? ImageOnOver : ImageOffOver;
            cbxButton.MouseEnter += (s, e) => cbxButton.Image = this.Checked ? ImageOnOver : ImageOffOver;
            cbxButton.MouseLeave += (s, e) => cbxButton.Image = this.Checked ? ImageOn     : ImageOff;

            cbxButton.Click      += (s, e) => this.Checked = !this.Checked;
        }

        /// <summary>
        /// チェック状態を取得または設定します.
        /// </summary>
        public bool Checked
        {
            get
            {
                return this.buttonChecked;
            }

            set
            {
                if (value == this.buttonChecked)
                {
                    return;
                }

                this.buttonChecked = value;

                cbxButton.Image = this.Checked ? ImageOn : ImageOff;

                this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "Checked");
            }
        }

        /// <summary>
        /// The on layout.
        /// </summary>
        /// <param name="e">
        /// The e.
        /// </param>
        protected override void OnLayout(LayoutEventArgs e)
        {
            // UIControlSetのサブパネルへのお引越し
            if (!this.moved)
            {
                var parent = this.Parent;
                while (parent != null)
                {
                    if (parent is UIControlSet)
                    {
                        var uiControlSet = parent as UIControlSet;
                        if (uiControlSet.LabelPos == UIControlSet.LabelPosition.Left)
                        {
                            LayoutEngineBase.SuspendLayout();

                            this.basePanel = new UIUserControl
                            {
                                Margin = new Padding(0),
                                Padding = new Padding(0),
                            };
                            this.Controls.Remove(this.label1);
                            this.Controls.Remove(this.cbxButton);
                            this.basePanel.Controls.Add(this.cbxButton);
                            this.basePanel.Controls.Add(this.label1);
                            uiControlSet.SubControls.Add(this.basePanel);

                            LayoutEngineBase.ResumeLayout();
                        }

                        this.moved = true;
                        break;
                    }

                    parent = parent.Parent;
                }
            }

            base.OnLayout(e);
        }

        /// <summary>
        /// ラベルの下に移動しているのでVisibilityを手動で通知する必要がある
        /// </summary>
        /// <param name="e">event args</param>
        protected override void OnVisibleChanged(EventArgs e)
        {
            base.OnVisibleChanged(e);

            if (this.basePanel != null)
            {
                if (this.Visibility == Visibility.Visible)
                {
                    this.basePanel.Margin = new Padding(0, 6, 3, 3);
                }

                this.basePanel.Visibility = this.Visibility;
            }
        }
    }
}
