﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.Foundation.Editting;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>ラベルカラーコンボボックス</summary>
    public class LabelColorComboBox : UIComboBox
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LabelColorComboBox()
        {
            this.DrawMode   = DrawMode.OwnerDrawFixed;
            this.ItemHeight = 20;
        }

        /// <summary>
        /// <see cref="E:System.Windows.Forms.ComboBox.DrawItem"/> イベントを発生させます。
        /// </summary>
        /// <param name="e">イベント データを格納している <see cref="T:System.Windows.Forms.DrawItemEventArgs"/>。</param>
        protected override void OnDrawItem(DrawItemEventArgs e)
        {
            base.OnDrawItem(e);

            e.DrawBackground();
            e.DrawFocusRectangle();

            if (e.Index == -1)
            {
                return;
            }

            var x = 2;

            // 色四角
            using (var brush = new SolidBrush(UIConstants.LabelColorColors[e.Index]))
            {
                const int Margin = 2;

                var size = e.Bounds.Height - (Margin * 2) - 1;

                x += Margin + 1;
                var iconRect = new Rectangle(x, e.Bounds.Y + Margin, size, size);
                e.Graphics.FillRectangle(brush, iconRect);
                e.Graphics.DrawRectangle(Pens.LightGray, iconRect);

                x += size;
            }

            // 名前
            {
                x += 2;
                const TextFormatFlags LeftFlag = TextFormatFlags.Left | TextFormatFlags.VerticalCenter;

                var rect = new Rectangle(x, e.Bounds.Y, e.Bounds.Width - x, e.Bounds.Height);
                var name = string.Format(Properties.Resources.ColorName, e.Index);

                TextRenderer.DrawText(e.Graphics, name, this.Font, rect, e.ForeColor, LeftFlag);
            }
        }
    }
}
