﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Primitives;

namespace EffectMaker.UIControls.Specifics.GradationEditor
{
    /// <summary>
    /// ３２キーグラデーションエディタ
    /// </summary>
    public class Gradation32KeyEditor : GradationEditor
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Gradation32KeyEditor()
        {
            this.CanAddRemoveKeys = true;
            this.CanReorderKeys = true;
            this.CanKeysOverlap = false;
            this.MovableEdgeKey = true;

            this.MinNumKeys = 1;
            this.MaxNumKeys = 32;
        }
    }
}
