﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;

//// ここを参考にしました。
//// http://stackoverflow.com/questions/605920/reasons-for-why-a-winforms-label-does-not-want-to-be-transparent

namespace EffectMaker.UIControls.Specifics.ColorPicker.SliderPanels
{
    /// <summary>
    /// 背景色透明ラベル
    /// </summary>
    public class TransparentLabel : UILabel
    {
        /// <summary>
        /// コンストラクト
        /// </summary>
        public TransparentLabel()
        {
            this.SetStyle(ControlStyles.Opaque, true);
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, false);
        }

        /// <summary>
        /// A <see cref="T:System.Windows.Forms.CreateParams"/> that contains the required creation parameters when the handle to the control is created.
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams parms = base.CreateParams;
                parms.ExStyle |= 0x20; // Turn on WS_EX_TRANSPARENT
                return parms;
            }
        }
    }
}
