﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Windows.Forms;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.UIControls.Specifics.ColorPicker
{
    /// <summary>
    /// カラーピッカーテスト
    /// </summary>
    public partial class ColorPickerTest : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorPickerTest()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// UiColorPicker1_ValueChanged
        /// </summary>
        /// <param name="sender">sender</param>
        /// <param name="e">e</param>
        private void UiColorPicker1_ValueChanged(object sender, Foundation.Utility.SequentialValueChangedEventArgs e)
        {
            this.uiLabel1.Text = string.Format(
                "({0}), {1}",
                this.uiColorPicker1.Value,
                e.Changing);
        }
    }
}
