﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UILogic.Commands;
using EffectMaker.UILogic.ViewModels;

namespace EffectMaker.UIControls.Specifics.Behaviors
{
    /// <summary>
    /// テクスチャページのラッププリセットボタン押下時の振る舞い
    /// </summary>
    public class TextureWrapPresetBehavior : Behavior<UIButton>, INotifyPropertyChanged
    {
        /// <summary>
        /// プリセットデータ
        /// </summary>
        private static readonly WrapPresetDataType[] WrapPresetData = new[]
        {
            new WrapPresetDataType
            {
                WrapTypeU = 0,
                WrapTypeV = 0
            },
            new WrapPresetDataType
            {
                WrapTypeU = 1,
                WrapTypeV = 1
            },
            new WrapPresetDataType
            {
                WrapTypeU = 2,
                WrapTypeV = 2
            }
        };

        /// <summary>
        /// Raised when the value of a property changes.
        /// </summary>
        public new event PropertyChangedEventHandler PropertyChanged;

        /// <summary>
        /// プリセットタイプ
        /// </summary>
        public enum WrapPresetTypes
        {
            /// <summary>
            /// ミラー
            /// </summary>
            Mirror = 0,

            /// <summary>
            /// リピート
            /// </summary>
            Repeat = 1,

            /// <summary>
            /// 無し
            /// </summary>
            Clamp = 2
        }

        /// <summary>
        /// 水平パターン
        /// </summary>
        public int WrapTypeU
        {
            get { return WrapPresetData[(int)this.WrapPresetType].WrapTypeU; }
            set { }
        }

        /// <summary>
        /// 垂直パターン
        /// </summary>
        public int WrapTypeV
        {
            get { return WrapPresetData[(int)this.WrapPresetType].WrapTypeV; }
            set { }
        }

        /// <summary>
        /// パターンタイプ
        /// </summary>
        public WrapPresetTypes WrapPresetType { get; set; }

        /// <summary>
        /// UIButtonにアタッチするときの処理を行います。
        /// </summary>
        protected override void OnAttached()
        {
            this.AssociatedObject.Click += this.OnClicked;
        }

        /// <summary>
        /// UIButtonからデタッチするときの処理を行います。
        /// </summary>
        protected override void OnDetaching()
        {
            this.AssociatedObject.Click -= this.OnClicked;
        }

        /// <summary>
        /// ボタンが押されたときの処理を行います。
        /// </summary>
        /// <param name="sender">sender</param>
        /// <param name="e">event</param>
        private void OnClicked(object sender, EventArgs e)
        {
            using (new CommandCombiner())
            {
                this.RaisePropertyChanged("WrapTypeU");
                this.RaisePropertyChanged("WrapTypeV");
            }
        }

        /// <summary>
        /// PropertyChanged イベントを発生させます。
        /// </summary>
        /// <param name="propertyName">変更されたプロパティの名前。</param>
        private void RaisePropertyChanged(string propertyName)
        {
            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        /// <summary>
        /// ラッププリセット
        /// </summary>
        private class WrapPresetDataType
        {
            /// <summary>
            /// 水平パターン分割
            /// </summary>
            public int WrapTypeU { get; set; }

            /// <summary>
            /// 垂直パターン分割
            /// </summary>
            public int WrapTypeV { get; set; }
        }
    }
}
