﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UILogic.Commands;
using EffectMaker.UILogic.ViewModels;

namespace EffectMaker.UIControls.Specifics.Behaviors
{
    /// <summary>
    /// テクスチャページのリピートプリセットボタン押下時の振る舞い
    /// </summary>
    public class TextureRepeatPresetBehavior : Behavior<UIButton>, INotifyPropertyChanged
    {
        /// <summary>
        /// プリセットデータ
        /// </summary>
        private static readonly RepeatCountPresetDataType[] RepeatCountPresetData = new[]
        {
            new RepeatCountPresetDataType
            {
                RepeatCount = 0
            },
            new RepeatCountPresetDataType
            {
                RepeatCount = 1
            },
            new RepeatCountPresetDataType
            {
                RepeatCount = 2
            },
            new RepeatCountPresetDataType
            {
                RepeatCount = 3
            }
        };

        /// <summary>
        /// Raised when the value of a property changes.
        /// </summary>
        public new event PropertyChangedEventHandler PropertyChanged;

        /// <summary>
        /// プリセットタイプ
        /// </summary>
        public enum RepeatCountPresetTypes
        {
            /// <summary>
            /// 繰り返し無し
            /// </summary>
            One = 0,

            /// <summary>
            /// U軸リピート
            /// </summary>
            URepeat = 1,

            /// <summary>
            /// V軸リピート
            /// </summary>
            VRepeat = 2,

            /// <summary>
            /// UV軸リピート
            /// </summary>
            UVRepeat = 3
        }

        /// <summary>
        /// 繰り返し数
        /// </summary>
        public int RepeatCount
        {
            get { return RepeatCountPresetData[(int)this.RepeatCountPresetType].RepeatCount; }
            set { }
        }

        /// <summary>
        /// パターンタイプ
        /// </summary>
        public RepeatCountPresetTypes RepeatCountPresetType { get; set; }

        /// <summary>
        /// UIButtonにアタッチするときの処理を行います。
        /// </summary>
        protected override void OnAttached()
        {
            this.AssociatedObject.Click += this.OnClicked;
        }

        /// <summary>
        /// UIButtonからデタッチするときの処理を行います。
        /// </summary>
        protected override void OnDetaching()
        {
            this.AssociatedObject.Click -= this.OnClicked;
        }

        /// <summary>
        /// ボタンが押されたときの処理を行います。
        /// </summary>
        /// <param name="sender">sender</param>
        /// <param name="e">event</param>
        private void OnClicked(object sender, EventArgs e)
        {
            using (new CommandCombiner())
            {
                this.RaisePropertyChanged("RepeatCount");
            }
        }

        /// <summary>
        /// PropertyChanged イベントを発生させます。
        /// </summary>
        /// <param name="propertyName">変更されたプロパティの名前。</param>
        private void RaisePropertyChanged(string propertyName)
        {
            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        /// <summary>
        /// 繰り返し数プリセット
        /// </summary>
        private class RepeatCountPresetDataType
        {
            /// <summary>
            /// リピートパターン
            /// </summary>
            public int RepeatCount { get; set; }
        }
    }
}
