﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UILogic.Commands;
using System;
using System.ComponentModel;

namespace EffectMaker.UIControls.Specifics.Behaviors
{
    /// <summary>
    /// テキストのクリアを処理するビヘイビアです。
    /// </summary>
    public class ResetTextBehavior : Behavior<UIButton>, INotifyPropertyChanged
    {
        /// <summary>
        /// テキストです。
        /// </summary>
        private string text;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ResetTextBehavior()
        {
            this.DefaultText = string.Empty;
            this.Text        = string.Empty;
        }

        /// <summary>
        /// デフォルトテキストを取得または設定します。
        /// </summary>
        public string DefaultText { get; set; }

        /// <summary>
        /// テキストを取得または設定します。
        /// </summary>
        public string Text
        {
            get { return this.text; }

            set
            {
                this.text = value;

                using (new CommandCombiner())
                {
                    this.PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Text"));
                }

                // ボタンの有効/無効を更新
                if (this.AssociatedObject != null)
                {
                    this.AssociatedObject.Enabled = (this.text != this.DefaultText);
                }
            }
        }

        /// <summary>
        /// ボタンにアタッチするときの処理を行います。
        /// </summary>
        protected override void OnAttached()
        {
            this.AssociatedObject.Click += this.OnClicked;

            // ボタンの有効/無効を更新
            this.AssociatedObject.Enabled = (this.text != this.DefaultText);
        }

        /// <summary>
        /// ボタンからデタッチするときの処理を行います。
        /// </summary>
        protected override void OnDetaching()
        {
            this.AssociatedObject.Click -= this.OnClicked;
        }

        /// <summary>
        /// ボタンが押されたときの処理を行います。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void OnClicked(object sender, EventArgs e)
        {
            this.Text = this.DefaultText;
        }

        #region INotifyPropertyChanged members

        /// <summary>
        /// プロパティの値が変更されたときに発生します。
        /// </summary>
        public new event PropertyChangedEventHandler PropertyChanged;

        #endregion
    }
}
