﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    using System;

    /// <summary>
    /// クローン関連のユーティリティです。
    /// </summary>
    public static class CloneableUtility
    {
        /// <summary>
        /// ICloneable オブジェクトを複製します。
        /// </summary>
        /// <typeparam name="TCloneable">複製対象の型パラメータです。</typeparam>
        /// <param name="cloneable">複製するオブジェクトです。</param>
        /// <returns>複製したオブジェクトです。引数が null の場合は null を返します。</returns>
        public static TCloneable Clone<TCloneable>(TCloneable cloneable)
            where TCloneable : ICloneable
        {
            if (cloneable == null)
            {
                return default(TCloneable);
            }

            return (TCloneable)cloneable.Clone();
        }

        /// <summary>
        /// ICloneable オブジェクトを複製を試みます。
        /// </summary>
        /// <param name="source">複製するオブジェクトです。</param>
        /// <returns>
        /// 複製したオブジェクトです。引数が null の場合は null を返します。
        /// 複製できない場合は、オブジェクトをそのまま返します。</returns>
        public static object TryClone(object source)
        {
            if (source is ICloneable)
            {
                return Clone<ICloneable>(source as ICloneable);
            }
            else
            {
                // そのまま返します。
                return source;
            }
        }
    }
}
