﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using System.Xml;
    using System.Xml.Schema;
    using System.Xml.Serialization;

    /// <summary>
    /// ストリームのシリアライズ用クラスです。
    /// ジェネリック型に対応して、複数の型を管理します。
    /// </summary>
    /// <typeparam name="TValue">ストリームの要素となる型です。</typeparam>
    public class StreamXml<TValue> : IXmlSerializable
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public StreamXml()
        {
            this.Stream = new TValue[0];
        }

        /// <summary>
        /// インデックス番号を指定してストリームの要素を取得または設定します。
        /// </summary>
        public TValue[] Stream { get; set; }

        /// <summary>
        /// XMLスキーマを取得します。
        /// </summary>
        /// <returns>XMLスキーマです。</returns>
        public XmlSchema GetSchema()
        {
            return null;
        }

        /// <summary>
        /// オブジェクトの XML 表現からオブジェクトを生成します。
        /// </summary>
        /// <param name="reader">オブジェクトの逆シリアル化元である　XmlReader です。</param>
        public void ReadXml(XmlReader reader)
        {
            bool isEmptyElement = reader.IsEmptyElement;
            reader.ReadStartElement();
            if (isEmptyElement)
            {
                return;
            }

            string content = reader.ReadString();

            if (string.IsNullOrEmpty(content))
            {
                // 空の行列として処理します。
                this.Stream = new TValue[0];
            }
            else
            {
                XmlSerializeUtility.SetCollectionByString(
                    content, this.Stream, (count) => this.Stream = new TValue[count]);
            }

            reader.ReadEndElement();
        }

        /// <summary>
        /// オブジェクトを XML 表現に変換します。
        /// </summary>
        /// <param name="writer">オブジェクトのシリアル化先の XmlWriter です。</param>
        public void WriteXml(XmlWriter writer)
        {
            writer.WriteAttributeString("Size", this.Stream.Length.ToString());

            string content = this.Stream.Length > 0 ? this.Stream[0].ToString() : string.Empty;
            for (int i = 1; i < this.Stream.Length; i++)
            {
                content += " " + this.Stream[i].ToString();
            }

            writer.WriteString(content);
        }
    }
}
