﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    using System.Xml.Serialization;

    /// <summary>
    /// XML文章への変換にシリアライザを利用するコンテンツを作成するリゾルバです。
    /// </summary>
    /// <typeparam name="TSerializedType">シリアライズする型です。</typeparam>
    public class XmlSerializedContentResolver<TSerializedType> : XmlContentResolver
        where TSerializedType : class
    {
        private XmlSerializer xmlSerializer = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="targetContentName">対象とするコンテンツの名前です。</param>
        public XmlSerializedContentResolver(string targetContentName)
            : base(targetContentName)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="targetContentName">対象とするコンテンツの名前です。</param>
        /// <param name="serializer">使用するXmlSerializerです。</param>
        public XmlSerializedContentResolver(string targetContentName, XmlSerializer serializer)
            : base(targetContentName)
        {
            this.xmlSerializer = serializer;
        }

        /// <summary>
        /// IXmlContentインスタンスを生成します。
        /// <para>
        /// IXmlContentのサブクラスを実体化する場合は本メソッドをオーバーライドします。
        /// </para>
        /// </summary>
        /// <param name="xmlSubDocument">コンテンツXML文章です。</param>
        /// <returns>コンテンツの実体です。</returns>
        protected override IXmlContent CreateXmlContent(string xmlSubDocument)
        {
            Ensure.Argument.StringNotEmpty(xmlSubDocument);

            // コンテンツを作成して返します。
            return XmlSerializedContent<TSerializedType>.FromXml(xmlSubDocument, this.xmlSerializer);
        }
    }
}
