﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    /// <summary>
    /// XMLシリアライザでシリアライズ処理される、データを表現するクラスです。
    /// </summary>
    public interface IXmlSerializedContent : IXmlContent
    {
        /// <summary>
        /// シリアライズ結果インスタンスを取得または設定します。
        /// </summary>
        object SerializeInstance { get; set; }
    }

    /// <summary>
    /// XMLシリアライザでシリアライズ処理される、データを表現するクラスです。
    /// </summary>
    /// <typeparam name="TSerializedType">シリアライズ処理されるデータ型です。</typeparam>
    public interface IXmlSerializedContent<TSerializedType> : IXmlSerializedContent
        where TSerializedType : class
    {
        /// <summary>
        /// シリアライズ結果インスタンスを取得または設定します。
        /// </summary>
        new TSerializedType SerializeInstance { get; set; }
    }
}
