﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;
    using System.ComponentModel;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ログのインターフェースです。
    /// </summary>
    public static class LogInputUtility
    {
        /// <summary>
        /// 例外の詳細情報をログ入力に追加します。
        /// </summary>
        /// <param name="logInput">ログ入力です。</param>
        /// <param name="exception">例外です。</param>
        public static void AddExceptionDetails(
            this ILogInput logInput, Exception exception)
        {
            Ensure.Argument.NotNull(logInput);
            Ensure.Argument.NotNull(exception);

            while (exception != null)
            {
                // MEMO:条件ビルドにしていますが、起動オプション等で
                // 動的に変更できてもよいかもしれません。
#if DEBUG
                logInput.AddMessage(exception.Message);
#endif
                logInput.AddMessage(exception.StackTrace);
                exception = exception.InnerException;
            }
        }
    }
}
