﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Conversion
{
    using System;

    /// <summary>
    /// コンバート処理中に名前付きプロパティとして、参照する
    /// プロパティに指定するアトリビュートです。
    /// <para>
    /// コンバート処理中に、検出されるとコンテキストに保存され、
    /// 以降のコンバートハンドラコードでアクセス可能です。
    /// 指定型が複数インスタンスを持つ場合、最後に検出されたアトリ
    /// ビュートに関してのみアクセスが可能となります。
    /// つまり、親子階層を持つ型に関しての利用はあまり想定していません。
    /// </para>
    /// </summary>
    public class NamedPropertyAttribute : Attribute
    {
        private string name;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">名前です。</param>
        public NamedPropertyAttribute(string name)
        {
            this.name = name;
        }

        /// <summary>
        /// 名前を取得、設定します。
        /// </summary>
        public string Name
        {
            get
            {
                return this.name;
            }

            set
            {
                Ensure.Argument.StringNotEmpty(value);
                this.name = value;
            }
        }
    }
}
