﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.Generic;

    /// <summary>
    /// 通知機能付き辞書コレクションです。
    /// </summary>
    /// <typeparam name="TKey">ディクショナリー内のキーのテンプレート型です。</typeparam>
    /// <typeparam name="TValue">ディクショナリー内の値のテンプレート型です。</typeparam>
    public class ObservableDictionary<TKey, TValue> : DictionaryDecorator<TKey, TValue>
    {
        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// デフォルトコンストラクタです。
        /// </summary>
        public ObservableDictionary()
            : base(new ObservableDictionaryBase<TKey, TValue>())
        {
        }

        /// <summary>
        /// デフォルトコンストラクタです。（ObservableDictionaryBaseを指定する版です。）
        /// </summary>
        /// <param name="dictionaryBase">指定するObservableDictionaryBaseオブジェクトです</param>
        public ObservableDictionary(ObservableDictionaryBase<TKey, TValue> dictionaryBase)
            : base(dictionaryBase)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">コピー元の列挙です。</param>
        public ObservableDictionary(IEnumerable<KeyValuePair<TKey, TValue>> source)
            : this()
        {
            foreach (KeyValuePair<TKey, TValue> item in source)
            {
                Add(item.Key, item.Value);
            }
        }
    }
}
