﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections;

    /// <summary>
    /// 列挙可能なコレクション用ユーティリティ
    /// </summary>
    public static class EnumerableUtility
    {
        /// <summary>
        /// 列挙可能なコレクションが空ではないか確認します。
        /// </summary>
        /// <param name="argument">コレクションです。</param>
        /// <returns>空でなければ true を返します。</returns>
        public static bool NotEmpty(IEnumerable argument)
        {
            Ensure.Argument.NotNull(argument);

            int count = 0;
            foreach (object each in argument)
            {
                Ensure.Argument.True(each != null);
                count++;
            }

            return count != 0;
        }
    }
}
