﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Attributes
{
    /// <summary>
    /// Represent a way to stringly tag anything in code.
    /// </summary>
    [AttributeUsage(AttributeTargets.All, AllowMultiple = true, Inherited = false)]
    public class TagAttribute : Attribute
    {
        /// <summary>
        /// Initializes the TagAttribute instance.
        /// </summary>
        /// <param name="id">Tag identifier.</param>
        public TagAttribute(string id)
        {
            this.ID = id;
        }

        /// <summary>
        /// Gets or sets the identifier of the tag.
        /// </summary>
        public string ID { get; set; }
    }
}
