﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.Manager
{
    /// <summary>
    /// エミッターカスタムアクション設定情報.
    /// </summary>
    [Serializable]
    public class CustomActionSettingInfo
    {
        /// <summary>
        /// キャプション
        /// </summary>
        private string caption;

        /// <summary>
        /// .csファイル名.
        /// </summary>
        [XmlAttribute("DataModel")]
        public string DataModelFileName { get; set; }

        /// <summary>
        /// .xamlファイル名.
        /// </summary>
        [XmlAttribute("UI")]
        public string XamlFileName { get; set; }

        /// <summary>
        /// .xamlフルファイルパス
        /// </summary>
        public string XamlFullFilepath
        {
            get
            {
                return Path.Combine(UserDataModelManager.ExeDirPath, "Addins", this.XamlFileName);
            }
        }

        /// <summary>
        /// キャプション
        /// xaml ルートコントロールのText属性をキャプションとして扱う
        /// </summary>
        public string Caption
        {
            get
            {
                if (string.IsNullOrEmpty(this.caption))
                {
                    this.caption = string.IsNullOrEmpty(this.XamlFileName) ? string.Empty : Path.GetFileNameWithoutExtension(this.XamlFileName);

                    try
                    {
                        // xaml ルートコントロールのText属性をキャプションとして扱う
                        using (var fs = new FileStream(this.XamlFullFilepath, FileMode.Open, FileAccess.Read))
                        {
                            using (var reader = XmlReader.Create(fs, new XmlReaderSettings()))
                            {
                                if (reader.Read())
                                {
                                    for (var i = 0; i != reader.AttributeCount; ++i)
                                    {
                                        reader.MoveToAttribute(i);

                                        if (reader.Name == "Text")
                                        {
                                            this.caption = reader.Value;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    catch
                    {
                    }
                }

                return this.caption;
            }
        }
    }
}
