﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノードです。
    /// </summary>
    [Serializable]
    public class ViewerData : DataModelBase
    {
        /// <summary>
        /// モデルリストです.
        /// </summary>
        private List<ModelData> modelList = null;

        /// <summary>
        /// 背景画像タブです.
        /// </summary>
        private ViewerBackgroundData viewerBackgroundData = null;

        /// <summary>
        /// カメラタブです。
        /// </summary>
        private ViewerCameraData viewerCameraData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerData() :
            base()
        {
            this.modelList = new List<ModelData>(){
                new ModelData(),
                new ModelData(),
                new ModelData(),
                new ModelData(),
                new ModelData(),
            };
        }

        /// <summary>
        /// モデルリストです.
        /// </summary>
        [DataModelPropertyGuid("28dc1b89-7c2c-430d-b12e-8ea50bfaf951")]
        public List<ModelData> ModelList
        {
            get { return this.GetDataModelListFromField(ref this.modelList); }
            set { this.SetDataModelListToField(ref this.modelList, value); }
        }

        /// <summary>
        /// 背景画像タブです.
        /// </summary>
        [DataModelPropertyGuid("442c7903-fc2b-4ce2-8917-f605fb8234c3")]
        public ViewerBackgroundData ViewerBackgroundData
        {
            get { return this.GetDataModelFromField(ref this.viewerBackgroundData, false); }
            set { this.SetDataModelToField(ref this.viewerBackgroundData, value); }
        }

        /// <summary>
        /// カメラタブです。
        /// </summary>
        [DataModelPropertyGuid("79afdf4d-9b69-4ada-ad90-ffc3f697335c")]
        public ViewerCameraData ViewerCameraData
        {
            get { return this.GetDataModelFromField(ref this.viewerCameraData, false); }
            set { this.SetDataModelToField(ref this.viewerCameraData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ModelList = srcDataModel.ModelList;
            this.ViewerBackgroundData = srcDataModel.ViewerBackgroundData;
            this.ViewerCameraData = srcDataModel.ViewerCameraData;

            return true;
        }
    }
}
