﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 自動移動.
    /// </summary>
    [Serializable]
    public class PreviewAutoMoveData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewAutoMoveData() :
            base()
        {
            this.MoveType = 0;
            this.MoveRadiusXZ = 8.0f;
            this.MoveSpeedXZ = 1.0f;
            this.ShakeAmplitudeY = 0.0f;
            this.ShakeSpeedY = 5.0f;
            this.RollSpeedZ = 0.0f;
        }

        /// <summary>
        /// 自動移動タイプ
        /// </summary>
        [DataModelPropertyGuid("adac800f-172f-42f7-b959-891ae2b9d314")]
        public int MoveType { get; set; }

        /// <summary>
        /// XZ移動半径
        /// </summary>
        [DataModelPropertyGuid("fa26a663-1d8d-48a0-9437-642a37a1678e")]
        public float MoveRadiusXZ { get; set; }

        /// <summary>
        /// XZ移動速度.
        /// </summary>
        [DataModelPropertyGuid("f8b9ab81-df61-4689-a31e-a556df040551")]
        public float MoveSpeedXZ { get; set; }

        /// <summary>
        /// Y揺れ振幅
        /// </summary>
        [DataModelPropertyGuid("93e16459-d576-4ce5-af5e-707b43b853a9")]
        public float ShakeAmplitudeY { get; set; }

        /// <summary>
        /// Y揺れ速度
        /// </summary>
        [DataModelPropertyGuid("12dae9ab-66ec-4cb8-ae0b-9c4b4135abed")]
        public float ShakeSpeedY { get; set; }

        /// <summary>
        /// Zロール速度
        /// </summary>
        [DataModelPropertyGuid("3847865c-3c85-4b1f-9847-694f6d3499f1")]
        public float RollSpeedZ { get; set; }

        /// <summary>
        /// 移動タイプアイテム.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("4b074d5e-3c88-408b-a005-0b3e34dd15d8")]
        public IEnumerable<ComboBoxItemType> MoveTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("無し", 0),
                    new ComboBoxItemType("XZ平面を移動", 1),
                };

            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as PreviewAutoMoveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MoveType = srcDataModel.MoveType;
            this.MoveRadiusXZ = srcDataModel.MoveRadiusXZ;
            this.MoveSpeedXZ = srcDataModel.MoveSpeedXZ;
            this.ShakeAmplitudeY = srcDataModel.ShakeAmplitudeY;
            this.ShakeSpeedY = srcDataModel.ShakeSpeedY;
            this.RollSpeedZ = srcDataModel.RollSpeedZ;

            return true;
        }
    }
}
