﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブ/キャラクタアニメグループデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicAnimationData() :
            base()
        {
            this.AnimationFolderPath = string.Empty;
            this.AnimationFilePath = string.Empty;
            this.AnimationFile = 0;
            this.AnimationRangeStartFrame = 0.0f;
            this.AnimationRangeEndFrame = -1.0f;
        }

        /// <summary>
        /// アニメーションフォルダパスです.
        /// </summary>
        [DataModelPropertyGuid("f55d156d-1ab0-49aa-9fa4-759de7070c22")]
        public string AnimationFolderPath { get; set; }

        /// <summary>
        /// アニメーションファイルパスです.
        /// </summary>
        [DataModelPropertyGuid("9cd4d85d-28cb-4198-8f92-157caf588b27")]
        public string AnimationFilePath { get; set; }

        /// <summary>
        /// アニメーションファイルです.
        /// </summary>
        [DataModelPropertyGuid("7ed75f55-10e1-443b-8c6c-74c27b62b726")]
        public int AnimationFile { get; set; }

        /// <summary>
        /// 再生範囲の開始フレームです.
        /// </summary>
        [DataModelPropertyGuid("45439890-682f-4136-9a37-a6fc6f81c586")]
        public float AnimationRangeStartFrame { get; set; }

        /// <summary>
        /// 再生範囲の終了フレームです.
        /// </summary>
        [DataModelPropertyGuid("e191a538-8c56-46e8-aed3-c8c30fe43b24")]
        public float AnimationRangeEndFrame { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ModelBasicAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationFolderPath = srcDataModel.AnimationFolderPath;
            this.AnimationFilePath = srcDataModel.AnimationFilePath;
            this.AnimationFile = srcDataModel.AnimationFile;
            this.AnimationRangeStartFrame = srcDataModel.AnimationRangeStartFrame;
            this.AnimationRangeEndFrame = srcDataModel.AnimationRangeEndFrame;

            return true;
        }
    }
}
