﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.DataModels;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Class for preview data.
    /// </summary>
    public class FluctuationBasicParamData : DataModelBase
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public FluctuationBasicParamData() :
            base()
        {
            this.WaveType = 4;
            this.ApplyAlpha = true;
            this.ApplyScale = true;
            this.Amplitude = 1.0f;
            this.Frequency = 20;
            this.PhaseRandom = false;
        }

        /// <summary>
        /// 波形タイプ.
        /// </summary>
        public int WaveType { get; set; }

        /// <summary>
        /// アルファに適用.
        /// </summary>
        public bool ApplyAlpha { get; set; }

        /// <summary>
        /// スケールに適用.
        /// </summary>
        public bool ApplyScale { get; set; }

        /// <summary>
        /// 振幅.
        /// </summary>
        public float Amplitude { get; set; }

        /// <summary>
        /// 周期.
        /// </summary>
        public int Frequency { get; set; }

        /// <summary>
        /// 位相.
        /// </summary>
        public bool PhaseRandom { get; set; }

        /// <summary>
        /// Set data from the source data model.
        /// </summary>
        /// <param name="src">The source data model.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as FluctuationBasicParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            this.WaveType = srcDataModel.WaveType;
            this.ApplyAlpha = srcDataModel.ApplyAlpha;
            this.ApplyScale = srcDataModel.ApplyScale;
            this.Amplitude = srcDataModel.Amplitude;
            this.Frequency = srcDataModel.Frequency;
            this.PhaseRandom = srcDataModel.PhaseRandom;

            return true;
        }
    }
}
