﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/スピンデータです。
    /// </summary>
    [Serializable]
    public class SpinParamData : DataModelBase
    {
        /// <summary>
        /// 回転速度のアニメーションテーブルです。
        /// </summary>
        private AnimationTableData velocityAnimationTable = null;

        /// <summary>
        /// 拡散速度のアニメーションの有無を表すフラグです。
        /// </summary>
        private AnimationTableData outerAnimationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public SpinParamData() :
            base()
        {
            this.SpinVelocity = 0.0f;
            this.SpinAxis = 1;
            this.SpinOuter = 0.0f;
            this.EnableVelocityAnimation = 0;
            this.EnableOuterAnimation = 0;
            this.VelocityLoopMode = 0;
            this.OuterLoopMode = 0;
            this.VelocityLoopEnd = 100;
            this.OuterLoopEnd = 100;
            this.VelocityRandomize = 0;
            this.OuterRandomize = 0;
        }

        /// <summary>
        /// 回転速度.
        /// </summary>
        [DataModelPropertyGuid("07bf2f8a-6756-4105-8d15-893c4c928c06")]
        public float SpinVelocity { get; set; }

        /// <summary>
        /// 軸です.
        /// </summary>
        [DataModelPropertyGuid("692241a0-c08d-467a-98e1-8fc02e29c083")]
        public int SpinAxis { get; set; }

        /// <summary>
        /// 拡散速度.
        /// </summary>
        [DataModelPropertyGuid("8fdce9b0-fab2-44ac-9103-12d0f451d9b8")]
        public float SpinOuter { get; set; }

        /// <summary>
        /// 回転速度のアニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("084640a7-6727-478e-b9a4-95b4dbdf65bd")]
        public int EnableVelocityAnimation { get; set; }

        /// <summary>
        /// 拡散速度のアニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("4155a4d8-25f0-40f8-a30e-cae4adc384b4")]
        public int EnableOuterAnimation { get; set; }

        /// <summary>
        /// 回転速度のアニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("3b9e9d5c-c0b8-4685-842e-4ea27e67972b")]
        public AnimationTableData VelocityAnimationTable
        {
            get { return this.GetObjectFromField(ref this.velocityAnimationTable, false); }
            set { this.SetISettableToField(ref this.velocityAnimationTable, value); }
        }

        /// <summary>
        /// 拡散速度のアニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("60ca061d-4023-420c-9a5b-a3c9b5edb44d")]
        public AnimationTableData OuterAnimationTable
        {
            get { return this.GetObjectFromField(ref this.outerAnimationTable, false); }
            set { this.SetISettableToField(ref this.outerAnimationTable, value); }
        }

        /// <summary>
        /// 回転速度のアニメーション再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("fd5b3e1a-f276-4ce9-9237-d3452c98fdb5")]
        public int VelocityLoopMode { get; set; }

        /// <summary>
        /// 拡散速度のアニメーション再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("0fcf5a29-3f45-47fe-b91b-373d0564659a")]
        public int OuterLoopMode { get; set; }

        /// <summary>
        /// 回転速度のアニメループ時終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("f90c724f-434a-48df-89b0-344c4e2963d6")]
        public int VelocityLoopEnd { get; set; }

        /// <summary>
        /// 拡散速度のアニメループ時終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("cc885e1c-c0cf-4e72-a9d1-711a0de10a4c")]
        public int OuterLoopEnd { get; set; }

        /// <summary>
        /// 回転速度のアニメ開始位置ランダム化フラグです。
        /// </summary>
        [DataModelPropertyGuid("c541a99b-4657-40b0-8c79-e96c0111d81e")]
        public int VelocityRandomize { get; set; }

        /// <summary>
        /// 拡散速度のアニメ開始位置ランダム化フラグです。
        /// </summary>
        [DataModelPropertyGuid("9c71f888-9a60-4385-8b64-f29a49f9275a")]
        public int OuterRandomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as SpinParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SpinVelocity = srcDataModel.SpinVelocity;
            this.SpinAxis = srcDataModel.SpinAxis;
            this.SpinOuter = srcDataModel.SpinOuter;
            this.EnableVelocityAnimation = srcDataModel.EnableVelocityAnimation;
            this.EnableOuterAnimation = srcDataModel.EnableOuterAnimation;
            this.VelocityAnimationTable = srcDataModel.VelocityAnimationTable;
            this.OuterAnimationTable = srcDataModel.OuterAnimationTable;
            this.VelocityLoopMode = srcDataModel.VelocityLoopMode;
            this.OuterLoopMode = srcDataModel.OuterLoopMode;
            this.VelocityLoopEnd = srcDataModel.VelocityLoopEnd;
            this.OuterLoopEnd = srcDataModel.OuterLoopEnd;
            this.VelocityRandomize = srcDataModel.VelocityRandomize;
            this.OuterRandomize = srcDataModel.OuterRandomize;

            return true;
        }
    }
}
