﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドランダム／詳細設定
    /// </summary>
    [Serializable]
    public class RandomDetailedOption : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomDetailedOption() :
            base()
        {
            this.EnableDetailedOption = false;
            this.WaveAddParam0 = 4.0f;
            this.WaveAddParam1 = 3.0f;
            this.WaveAddParam2 = 2.0f;
            this.WaveAddParam3 = 1.5f;
            this.WaveCycleRate0 = 0.6f;
            this.WaveCycleRate1 = 0.42f;
            this.WaveCycleRate2 = 0.23f;
            this.WaveCycleRate3 = 0.15f;
        }

        /// <summary>
        /// 詳細設定のON/OFF
        /// </summary>
        [DataModelPropertyGuid("b01b3b03-cc42-452c-82be-f2292c95baed")]
        public bool EnableDetailedOption { get; set; }

        /// <summary>
        /// 波形0の重み係数
        /// </summary>
        [DataModelPropertyGuid("d7d0bef6-4fd0-461b-815e-16e173126b41")]
        public float WaveAddParam0 { get; set; }

        /// <summary>
        /// 波形1の重み係数
        /// </summary>
        [DataModelPropertyGuid("ce4dbc0f-1740-49eb-b44e-391de2afe135")]
        public float WaveAddParam1 { get; set; }

        /// <summary>
        /// 波形2の重み係数
        /// </summary>
        [DataModelPropertyGuid("d86291b1-3674-4e78-8583-16132a984452")]
        public float WaveAddParam2 { get; set; }

        /// <summary>
        /// 波形3の重み係数
        /// </summary>
        [DataModelPropertyGuid("a64a406b-70e9-4147-bc65-47b89a0134d5")]
        public float WaveAddParam3 { get; set; }

        /// <summary>
        /// 波形0の周期の基本周期に対する比率。
        /// </summary>
        [DataModelPropertyGuid("a94d57d0-7160-4a19-b91a-dc785969ad84")]
        public float WaveCycleRate0 { get; set; }

        /// <summary>
        /// 波形1の周期の基本周期に対する比率。
        /// </summary>
        [DataModelPropertyGuid("ad48a8fd-c528-4284-8455-408488c5e7a5")]
        public float WaveCycleRate1 { get; set; }

        /// <summary>
        /// 波形2の周期の基本周期に対する比率。
        /// </summary>
        [DataModelPropertyGuid("d16ba26c-eb31-448d-8b30-0fb0a0c3e1f9")]
        public float WaveCycleRate2 { get; set; }

        /// <summary>
        /// 波形3の周期の基本周期に対する比率。
        /// </summary>
        [DataModelPropertyGuid("88c70ad6-da79-493f-9178-da758ff32c86")]
        public float WaveCycleRate3 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as RandomDetailedOption;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableDetailedOption = srcDataModel.EnableDetailedOption;
            this.WaveAddParam0 = srcDataModel.WaveAddParam0;
            this.WaveAddParam1 = srcDataModel.WaveAddParam1;
            this.WaveAddParam2 = srcDataModel.WaveAddParam2;
            this.WaveAddParam3 = srcDataModel.WaveAddParam3;
            this.WaveCycleRate0 = srcDataModel.WaveCycleRate0;
            this.WaveCycleRate1 = srcDataModel.WaveCycleRate1;
            this.WaveCycleRate2 = srcDataModel.WaveCycleRate2;
            this.WaveCycleRate3 = srcDataModel.WaveCycleRate3;

            return true;
        }
    }
}
