﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/収束データです。
    /// </summary>
    [Serializable]
    public class ConvergeParamData : DataModelBase
    {
        /// <summary>
        /// 位置.
        /// </summary>
        private Vector3f position = null;

        /// <summary>
        /// 収束力のアニメーションテーブルです。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ConvergeParamData() :
            base()
        {
            this.Ratio = 0.0f;
            this.Position = new Vector3f(0.0f, 0.0f, 0.0f);
            this.FollowEmitter = false;
            this.EnableAnimation = 0;
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
        }

        /// <summary>
        /// 収束力.
        /// </summary>
        [DataModelPropertyGuid("1d200814-797d-44e1-bb8e-f3e62ac11ce3")]
        public float Ratio { get; set; }

        /// <summary>
        /// 位置.
        /// </summary>
        [DataModelPropertyGuid("7934cf1b-729d-416a-9a28-eaa507c5bf36")]
        public Vector3f Position
        {
            get { return this.GetObjectFromField(ref this.position, false); }
            set { this.SetISettableToField(ref this.position, value); }
        }

        /// <summary>
        /// 位置の追従タイプ.
        /// </summary>
        [DataModelPropertyGuid("b7516a69-7a5c-44d8-a6f1-ede119b91c1c")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// 収束力のアニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("671e8d10-91fb-42fc-b053-740deaef6a2e")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// 収束力のアニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("212a8b4c-28b9-40be-a597-f487115a5a16")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        ///
        /// </summary>
        [DataModelPropertyGuid("710eff85-5219-4bd9-b445-ab573f2a48c3")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("ea2268ca-f62b-4d8b-b725-881f050f05e2")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("c34ac6fa-46ff-49d0-8bf8-d33c884e3753")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ConvergeParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Ratio = srcDataModel.Ratio;
            this.Position = srcDataModel.Position;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
