﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Class for emitter set basic setting tab data.
    /// </summary>
    [Serializable]
    public class EmitterSetBasicData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetBasicData() :
            base()
        {
            this.Comment = string.Empty;
            this.LabelColor = 0;
        }

        /// <summary>
        /// Get the name of the emitter set.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("48dd1a0f-88b8-4767-a4e0-33e87e586c5b")]
        public string Name
        {
            get
            {
                var eset = this.Parent as EmitterSetData;
                if (eset == null)
                {
                    return string.Empty;
                }

                return eset.Name;
            }
        }

        /// <summary>
        /// Get the file path of the emitter set.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e441551b-0f7f-4722-8b9e-ba7327093c0c")]
        public string FilePath
        {
            get
            {
                var eset = this.Parent as EmitterSetData;
                if (eset == null)
                {
                    return string.Empty;
                }

                return eset.FilePath;
            }
        }

        /// <summary>
        /// The description for the emitter set.
        /// </summary>
        [DataModelPropertyGuid("d8892ebe-e7db-485b-bc48-ea27d841209d")]
        public string Comment { get; set; }

        /// <summary>
        /// The label color index for the emitter set to show on EffectBrowser.
        /// </summary>
        [DataModelPropertyGuid("848b7b0e-b3dc-4b18-8afe-6f96dced96ad")]
        public int LabelColor { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterSetBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Comment = srcDataModel.Comment;
            this.LabelColor = srcDataModel.LabelColor;

            return true;
        }
    }
}
