﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャ座標アニメーションデータです。
    /// </summary>
    [Serializable]
    public class EmitterTextureUvAnimationData : DataModelBase
    {
        /// <summary>
        /// UVスクロールの加算値です.
        /// </summary>
        private Vector2f uvScrollAddValue = null;

        /// <summary>
        /// UVスクロールの初期値です.
        /// </summary>
        private Vector2f uvScrollInitialValue = null;

        /// <summary>
        /// UVスクロールの初期値ランダム値です.
        /// </summary>
        private Vector2f uvScrollInitialRandomValue = null;

        /// <summary>
        /// UVスケールの加算値です.
        /// </summary>
        private Vector2f uvScaleAddValue = null;

        /// <summary>
        /// UVスケールの初期値です.
        /// </summary>
        private Vector2f uvScaleInitialValue = null;

        /// <summary>
        /// UVスケールの初期値ランダム値です.
        /// </summary>
        private Vector2f uvScaleInitialRandomValue = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureUvAnimationData() :
            base()
        {
            this.EnableUvScrollAnimation = false;
            this.EnableUvRotAnimation = false;
            this.EnableUvScaleAnimation = false;
            this.UvScrollAddValue = new Vector2f(0.0f, 0.0f);
            this.UvScrollInitialValue = new Vector2f(0.0f, 0.0f);
            this.UvScrollInitialRandomValue = new Vector2f(0.0f, 0.0f);
            this.UvRotationAddValue = 0;
            this.UvRotationInitialValue = 0;
            this.UvRotationInitialRandomValue = 0;
            this.UvScaleAddValue = new Vector2f(0.0f, 0.0f);
            this.UvScaleInitialValue = new Vector2f(1.0f, 1.0f);
            this.UvScaleInitialRandomValue = new Vector2f(0.0f, 0.0f);
        }

        /// <summary>
        /// Get or set the flag indicating whether to enable UV scroll animation.
        /// </summary>
        [DataModelPropertyGuid("462d0a1f-35dd-4519-bfe6-21912d553e14")]
        public bool EnableUvScrollAnimation { get; set; }

        /// <summary>
        /// Get or set the flag indicating whether to enable UV rotation animation.
        /// </summary>
        [DataModelPropertyGuid("6c04e929-236d-445a-a001-af02b34fbb97")]
        public bool EnableUvRotAnimation { get; set; }

        /// <summary>
        /// Get or set the flag indicating whether to enable UV scale animation.
        /// </summary>
        [DataModelPropertyGuid("23974ff9-26cc-4494-be63-4db604a517ba")]
        public bool EnableUvScaleAnimation { get; set; }

        /// <summary>
        /// UVスクロールの加算値です.
        /// </summary>
        [DataModelPropertyGuid("755c9505-599b-4c9a-a1a4-2b0d4078848d")]
        public Vector2f UvScrollAddValue
        {
            get { return this.GetObjectFromField(ref this.uvScrollAddValue, false); }
            set { this.SetISettableToField(ref this.uvScrollAddValue, value); }
        }

        /// <summary>
        /// UVスクロールの初期値です.
        /// </summary>
        [DataModelPropertyGuid("515f9b88-3c9c-4ce5-beeb-f8394f24dae4")]
        public Vector2f UvScrollInitialValue
        {
            get { return this.GetObjectFromField(ref this.uvScrollInitialValue, false); }
            set { this.SetISettableToField(ref this.uvScrollInitialValue, value); }
        }

        /// <summary>
        /// UVスクロールの初期値ランダム値です.
        /// </summary>
        [DataModelPropertyGuid("e2508e6a-0c9c-4d78-bfac-33fa9589ea9b")]
        public Vector2f UvScrollInitialRandomValue
        {
            get { return this.GetObjectFromField(ref this.uvScrollInitialRandomValue, false); }
            set { this.SetISettableToField(ref this.uvScrollInitialRandomValue, value); }
        }

        /// <summary>
        /// UV回転の加算値です.
        /// </summary>
        [DataModelPropertyGuid("1b6f37c4-0352-4c24-b0bc-11bba56db2ed")]
        public float UvRotationAddValue { get; set; }

        /// <summary>
        /// UV回転の初期値です.
        /// </summary>
        [DataModelPropertyGuid("369a82cc-4391-4bea-9a9f-820053d2241e")]
        public float UvRotationInitialValue { get; set; }

        /// <summary>
        /// UV回転の初期値ランダム値です.
        /// </summary>
        [DataModelPropertyGuid("3ba74e99-315a-4702-825e-c85f27bcddb2")]
        public float UvRotationInitialRandomValue { get; set; }

        /// <summary>
        /// UVスケールの加算値です.
        /// </summary>
        [DataModelPropertyGuid("f02abd81-835e-4dee-8d3c-27765ad45584")]
        public Vector2f UvScaleAddValue
        {
            get { return this.GetObjectFromField(ref this.uvScaleAddValue, false); }
            set { this.SetISettableToField(ref this.uvScaleAddValue, value); }
        }

        /// <summary>
        /// UVスケールの初期値です.
        /// </summary>
        [DataModelPropertyGuid("05086c12-4be1-485f-a5ba-11540e41fbdc")]
        public Vector2f UvScaleInitialValue
        {
            get { return this.GetObjectFromField(ref this.uvScaleInitialValue, false); }
            set { this.SetISettableToField(ref this.uvScaleInitialValue, value); }
        }

        /// <summary>
        /// UVスケールの初期値ランダム値です.
        /// </summary>
        [DataModelPropertyGuid("db31e5be-c6f5-4993-ad5c-e38629f3d2d7")]
        public Vector2f UvScaleInitialRandomValue
        {
            get { return this.GetObjectFromField(ref this.uvScaleInitialRandomValue, false); }
            set { this.SetISettableToField(ref this.uvScaleInitialRandomValue, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterTextureUvAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableUvScrollAnimation = srcDataModel.EnableUvScrollAnimation;
            this.EnableUvRotAnimation = srcDataModel.EnableUvRotAnimation;
            this.EnableUvScaleAnimation = srcDataModel.EnableUvScaleAnimation;
            this.UvScrollAddValue = srcDataModel.UvScrollAddValue;
            this.UvScrollInitialValue = srcDataModel.UvScrollInitialValue;
            this.UvScrollInitialRandomValue = srcDataModel.UvScrollInitialRandomValue;
            this.UvRotationAddValue = srcDataModel.UvRotationAddValue;
            this.UvRotationInitialValue = srcDataModel.UvRotationInitialValue;
            this.UvRotationInitialRandomValue = srcDataModel.UvRotationInitialRandomValue;
            this.UvScaleAddValue = srcDataModel.UvScaleAddValue;
            this.UvScaleInitialValue = srcDataModel.UvScaleInitialValue;
            this.UvScaleInitialRandomValue = srcDataModel.UvScaleInitialRandomValue;

            return true;
        }
    }
}
