﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// パーティクルタブデータです.
    /// </summary>
    [Serializable]
    public class EmitterParticleData : DataModelBase
    {
        /// <summary>
        /// パーティクル寿命グループです.
        /// </summary>
        private EmitterParticleLifeData emitterParticleLifeData = null;

        /// <summary>
        /// 運動量ランダムグループです.
        /// </summary>
        private EmitterParticleRandomData emitterParticleRandomData = null;

        /// <summary>
        /// パーティクル形状グループです.
        /// </summary>
        private EmitterParticleShapeData emitterParticleShapeData = null;

        /// <summary>
        /// 揺らぎグループです.
        /// </summary>
        private EmitterParticleFluctuationData emitterParticleFluctutaionData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleData() :
            base()
        {
        }

        /// <summary>
        /// パーティクル寿命グループです.
        /// </summary>
        [DataModelPropertyGuid("23786016-2bd0-49cd-9d1f-168c6a7746e3")]
        public EmitterParticleLifeData EmitterParticleLifeData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleLifeData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleLifeData, value); }
        }

        /// <summary>
        /// 運動量ランダムグループです.
        /// </summary>
        [DataModelPropertyGuid("841246d5-b994-4d22-a697-a212e5e9df81")]
        public EmitterParticleRandomData EmitterParticleRandomData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleRandomData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleRandomData, value); }
        }

        /// <summary>
        /// パーティクル形状グループです.
        /// </summary>
        [DataModelPropertyGuid("a8921058-beb6-45c2-b843-1d5a105553c9")]
        public EmitterParticleShapeData EmitterParticleShapeData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleShapeData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleShapeData, value); }
        }

        /// <summary>
        /// 揺らぎグループです.
        /// </summary>
        [DataModelPropertyGuid("5ae6d108-cac3-41b1-a159-6b7c5f46717e")]
        public EmitterParticleFluctuationData EmitterParticleFluctutaionData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleFluctutaionData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleFluctutaionData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterParticleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterParticleLifeData = srcDataModel.EmitterParticleLifeData;
            this.EmitterParticleRandomData = srcDataModel.EmitterParticleRandomData;
            this.EmitterParticleShapeData = srcDataModel.EmitterParticleShapeData;
            this.EmitterParticleFluctutaionData = srcDataModel.EmitterParticleFluctutaionData;

            return true;
        }
    }
}
