﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Xml;
using System.Xml.Schema;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Manager;
using EffectMaker.Foundation.Collections.Generic;
using System;
using System.Xml.Serialization;
using NWCore.src.Remake.DataModel.DataModels.Emitter;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムシェーダータブデータです.
    /// </summary>
    [Serializable]
    public class EmitterCustomShaderData : DataModelBase, IXmlSerializable
    {
        /// <summary>
        /// Get or set the custom shader user data list.
        /// </summary>
        private ArrayCollection<EmitterCustomShaderSettingData> settings = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCustomShaderData() :
            base()
        {
            this.SelectedSettingIndex = -1;
        }

        /// <summary>
        /// 選択中セッティングインデックスです
        /// </summary>
        [DataModelPropertyGuid("dffbc501-1945-4ec1-80af-dff999e7896e")]
        public int SelectedSettingIndex { get; set; }

        /// <summary>
        /// Get or set the selected custom shader settings data.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("ee0ac50f-ec8d-4a96-aa25-7c3db40e6e3a")]
        public EmitterCustomShaderSettingData SelectedSettingData
        {
            get
            {
                if (this.SelectedSettingIndex < 0 || this.SelectedSettingIndex > this.Settings.Count)
                {
                    return null;
                }

                return this.Settings[this.SelectedSettingIndex];
            }
        }

        /// <summary>
        /// Get the custom shader flags of the selected settings.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("7264c5d7-2884-4d64-bffe-cd32b4bffdbe")]
        public uint SelectedSettingFlags
        {
            get
            {
                var selectedData = this.SelectedSettingData;
                if (selectedData == null)
                {
                    return 0;
                }

                return selectedData.Flags;
            }
        }

        /// <summary>
        /// Get or set the custom shader user data list.
        /// </summary>
        [DataModelPropertyGuid("d0ef4798-80b8-425c-b0ff-82e56351c5eb")]
        public ArrayCollection<EmitterCustomShaderSettingData> Settings
        {
            get
            {
                return this.settings;
            }

            set
            {
                if (this.settings == null)
                {
                    this.settings = new ArrayCollection<EmitterCustomShaderSettingData>(8);
                }

                this.settings.Set(value);
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterCustomShaderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SelectedSettingIndex = srcDataModel.SelectedSettingIndex;
            this.Settings = srcDataModel.Settings;

            return true;
        }

        public XmlSchema GetSchema()
        {
            // NO RETURN
            return null;
        }

        public void ReadXml(XmlReader reader)
        {
            // DO NOTHING
        }

        public void WriteXml(XmlWriter writer)
        {
            writer.WriteElementString("SelectedSettingIndex", this.SelectedSettingIndex.ToString("D"));
            writer.WriteStartElement("Settings");
            writer.WriteAttributeString("Count", "8");
            int settingCount = 0;
            foreach (var setting in Settings)
            {
                if (setting is EmitterCustomShaderConvertingData)
                {
                    var convertData = setting as EmitterCustomShaderConvertingData;
                    writer.WriteStartElement(convertData.Name);
                    writer.WriteAttributeString("xsi:type", convertData.Name);

                    writer.WriteElementString("Flags", convertData.Flags.ToString("D"));

                    for (int i = 0; i < convertData.Switches.Count; ++i)
                    {
                        writer.WriteElementString(
                            string.Format("Switch{0}", i),
                            convertData.Switches[i].ToString("D"));
                    }

                    for (int i = 0; i < convertData.Params.Count; ++i)
                    {
                        writer.WriteElementString(
                            string.Format("FloatParam{0}", i),
                            convertData.Params[i].ToString());
                    }

                    writer.WriteEndElement();
                    ++settingCount;
                }
            }

            for (int i = 0; i < 8 - settingCount; ++i)
            {
                writer.WriteStartElement("EmitterCustomShaderSettingData");
                writer.WriteAttributeString("xsi:nil", bool.TrueString);
                writer.WriteEndElement();
            }

            writer.WriteEndElement();
        }
    }
}
