﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// チャイルドエミッタのみ有効となる、継承項目設定用のデータモデルです.
    /// </summary>
    [Serializable]
    public class EmitterBasicInheritanceData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicInheritanceData() :
            base()
        {
            this.EnableVelocity = false;
            this.VelocityInheritanceRate = 1;
            this.EnableScale = true;
            this.ScaleInheritanceRate = 1;
            this.EnableRotation = true;
            this.EnableDrawPath = true;
            this.EnablePreDraw = false;
            this.EnableColorScale = false;
            this.EnableColor0 = false;
            this.EnableColor1 = false;
            this.EnableAlpha0 = true;
            this.EnableAlpha1 = true;
        }

        /// <summary>
        /// 速度の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("6f8e55da-ff39-40fa-894e-9080a3912f8d")]
        public bool EnableVelocity { get; set; }

        /// <summary>
        /// 速度の継承率
        /// </summary>
        [DataModelPropertyGuid("8fe59739-2165-4a21-85b7-b76a6f819c7e")]
        public float VelocityInheritanceRate { get; set; }

        /// <summary>
        /// スケールの継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("7cdf37c1-5e2e-4c36-ae68-894e2b1ece08")]
        public bool EnableScale { get; set; }

        /// <summary>
        /// スケールの継承率
        /// </summary>
        [DataModelPropertyGuid("891a8c11-ec71-445e-adcf-4ccced4e507d")]
        public float ScaleInheritanceRate { get; set; }

        /// <summary>
        /// 回転の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("54f0bd8c-7e80-4b67-b484-2fc039a26423")]
        public bool EnableRotation { get; set; }

        /// <summary>
        /// 描画パスの継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("9d6ce869-a9be-4f9a-a139-f0fd5c3e3149")]
        public bool EnableDrawPath { get; set; }

        /// <summary>
        /// 上位の階層より先に描画するか
        /// </summary>
        [DataModelPropertyGuid("4033fdb9-0ce6-484c-9502-390de423657a")]
        public bool EnablePreDraw { get; set; }

        /// <summary>
        /// カラースケールの継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("c0ecf499-bf5c-4a7e-bcc8-e1d6a21cec26")]
        public bool EnableColorScale { get; set; }

        /// <summary>
        /// カラー0の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("46f13bc0-3915-46a9-8930-d0336331f8ad")]
        public bool EnableColor0 { get; set; }

        /// <summary>
        /// カラー1の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("050a32cd-1ae3-4a47-936d-11efdf60603b")]
        public bool EnableColor1 { get; set; }

        /// <summary>
        /// アルファ0の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("31d8e7a9-ab26-4a79-8bc3-5112898d5a8c")]
        public bool EnableAlpha0 { get; set; }

        /// <summary>
        /// アルファ1の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("7d72c737-a69f-4d72-a557-1eb5b42ee750")]
        public bool EnableAlpha1 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterBasicInheritanceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableVelocity = srcDataModel.EnableVelocity;
            this.VelocityInheritanceRate = srcDataModel.VelocityInheritanceRate;
            this.EnableScale = srcDataModel.EnableScale;
            this.ScaleInheritanceRate = srcDataModel.ScaleInheritanceRate;
            this.EnableRotation = srcDataModel.EnableRotation;
            this.EnableDrawPath = srcDataModel.EnableDrawPath;
            this.EnablePreDraw = srcDataModel.EnablePreDraw;
            this.EnableColorScale = srcDataModel.EnableColorScale;
            this.EnableColor0 = srcDataModel.EnableColor0;
            this.EnableColor1 = srcDataModel.EnableColor1;
            this.EnableAlpha0 = srcDataModel.EnableAlpha0;
            this.EnableAlpha1 = srcDataModel.EnableAlpha1;

            return true;
        }
    }
}
