﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectMaker.DataModel.DataModels.Attributes
{
    /// <summary>
    /// Custom attribute for assigning output field of a converter.
    /// </summary>
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = false)]
    public class ConverterOutputAttribute : System.Attribute
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="valueType">The value type of the output field.</param>
        /// <param name="description">The description of the output field.</param>
        public ConverterOutputAttribute(Type valueType, string description)
        {
            this.ValueType = valueType;
            this.Description = description;
        }

        /// <summary>
        /// Get the value type.
        /// </summary>
        public Type ValueType { get; private set; }

        /// <summary>
        /// Get the description of the field.
        /// </summary>
        public string Description { get; private set; }
    }
}
