﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_7.Build_0.Revision_0
{
    /// <summary>
    /// カラーアニメーション編集データ
    /// </summary>
    public sealed class ColorEditData : BaseDataModel<ColorEditData>
    {
        #region プロパティ

        /// <summary>
        /// カラー設定タイプ
        /// </summary>
        public Constances.ColorSettingType ColorType { get; set; }

        /// <summary>
        /// アニメーションタイプ。
        /// </summary>
        public ParticleAnimationTypes AnimType { get; set; }

        /// <summary>
        /// アニメーションカラー
        /// </summary>
        public RgbaColor Color1 { get; set; }

        /// <summary>
        /// アニメーションカラー
        /// </summary>
        public RgbaColor Color2 { get; set; }

        /// <summary>
        /// アニメーションカラー
        /// </summary>
        public RgbaColor Color3 { get; set; }

        /// <summary>
        /// アニメーションタイム
        /// </summary>
        public int Time1 { get; set; }

        /// <summary>
        /// アニメーションタイム
        /// </summary>
        public int Time2 { get; set; }

        /// <summary>
        /// アニメーションタイム
        /// </summary>
        public int Time3 { get; set; }

        /// <summary>
        /// リピート数
        /// </summary>
        public int NumRepeat { get; set; }

        /// <summary>
        /// 繰り返し開始位置
        /// </summary>
        public bool RandInitColor { get; set; }

        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorEditData()
        {
            this.Color1 = new RgbaColor();
            this.Color2 = new RgbaColor();
            this.Color3 = new RgbaColor();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorEditData(ColorEditData source)
            : this()
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.ColorType = Constances.ColorSettingType.Constant;
            this.AnimType = ParticleAnimationTypes.Anim3Key;
            this.Color1.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.Color2.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.Color3.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.Time1 = 20;
            this.Time2 = 60;
            this.Time3 = 80;
            this.NumRepeat = 1;
            this.RandInitColor = false;
        }

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set(ColorEditData source)
        {
            this.ColorType = source.ColorType;
            this.AnimType = source.AnimType;
            this.Color1.Set(source.Color1);
            this.Color2.Set(source.Color2);
            this.Color3.Set(source.Color3);
            this.Time1 = source.Time1;
            this.Time2 = source.Time2;
            this.Time3 = source.Time3;
            this.NumRepeat = source.NumRepeat;
            this.RandInitColor = source.RandInitColor;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override ColorEditData Clone()
        {
            return new ColorEditData(this);
        }
    }

}
