﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_5.Build_0.Revision_0
{
    /// <summary>
    /// アニメーション編集データ
    /// </summary>
    public sealed class ChildAssistData : BaseDataModel<ChildAssistData>
    {
        #region Properties

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_childColor { get; set; }

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_childInheritanceColor { get; set; }

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_childConstColor0 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public RgbaColor UI_childConstColor1 { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_childLife { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2 UI_childRotBasis { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childInitRot { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childInitRotRand { get; set; }

        /// <summary>
        /// 回転方向ランダム
        /// </summary>
        public Vector3i UI_childRotDirRand { get; set; }

        /// <summary>
        /// 減衰率
        /// </summary>
        public float UI_childRotResist { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childRotVel { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childRotVelRand { get; set; }

        /// <summary>
        ///
        /// </summary>
        public PtclRotType UI_childRotType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Constances.ColorCommonType UI_childColorType { get; set; }

        /// <summary>
        /// カラースケール継承
        /// </summary>
        public bool UI_isChildColorScaleInherited { get; set; }

        /// <summary>
        /// カラースケール
        /// </summary>
        public float UI_childColorScale { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Constances.ColorInheritType UI_childColorInheritType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_childAlphaSec { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_childAlphaBaseSec { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_childScaleSec { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2i UI_childScaleTarget { get; set; }

        /// <summary>
        ///
        /// </summary>
        public AlphaDst UI_childAlphaDstType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3 UI_childGravityDir { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_childGravity { get; set; }

        /// <summary>
        ///
        /// </summary>
        public BlendType UI_childBlendType { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public ChildAssistData()
        {
            this.UI_childAlphaDstType = AlphaDst.NumAlphaDst;
            this.UI_childBlendType = BlendType.Normal;
            this.UI_childColor = new RgbaColor();
            this.UI_childConstColor0 = new RgbaColor();
            this.UI_childConstColor1 = new RgbaColor();
            this.UI_childGravityDir = new Vector3();
            this.UI_childInheritanceColor = new RgbaColor();
            this.UI_childInitRot = new Vector3i();
            this.UI_childInitRotRand = new Vector3i();
            this.UI_childRotDirRand = new Vector3i();
            this.UI_childRotBasis = new Vector2();
            this.UI_childRotType = PtclRotType.NoWork;
            this.UI_childRotVel = new Vector3i();
            this.UI_childRotVelRand = new Vector3i();
            this.UI_childScaleTarget = new Vector2i();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public ChildAssistData(ChildAssistData source)
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.UI_childColor.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.UI_childConstColor0.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.UI_childConstColor1.Set(1.0f, 1.0f, 1.0f, 1.0f);
            this.UI_childInheritanceColor.Set(0.0f, 0.0f, 0.0f, 0.0f);
            this.UI_childRotDirRand.Set(0, 0, 0);
            this.UI_childGravityDir.Set(0, -1, 0);

            this.UI_childRotResist = 1.0f;
            this.UI_childAlphaDstType = AlphaDst.ModulateTex;
            this.UI_childAlphaSec = 100;
            this.UI_childColorInheritType = Constances.ColorInheritType.ModulateNoAnim;
            this.UI_childColorType = Constances.ColorCommonType.Modulate;
            this.UI_isChildColorScaleInherited = false;
            this.UI_childColorScale = 1.0f;
            this.UI_childLife = 60;
            this.UI_childScaleSec = 100;
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(ChildAssistData source)
        {
            Ensure.Argument.NotNull(source);

            this.UI_childColor.Set(source.UI_childColor);
            this.UI_childConstColor0.Set(source.UI_childConstColor0);
            this.UI_childConstColor1.Set(source.UI_childConstColor1);
            this.UI_childGravityDir.Set(source.UI_childGravityDir);
            this.UI_childInheritanceColor.Set(source.UI_childInheritanceColor);
            this.UI_childInitRot.Set(source.UI_childInitRot);
            this.UI_childInitRotRand.Set(source.UI_childInitRotRand);
            this.UI_childRotDirRand.Set(source.UI_childRotDirRand);
            this.UI_childRotBasis.Set(source.UI_childRotBasis);
            this.UI_childRotVel.Set(source.UI_childRotVel);
            this.UI_childRotVelRand.Set(source.UI_childRotVelRand);
            this.UI_childScaleTarget.Set(source.UI_childScaleTarget);

            this.UI_childRotResist = source.UI_childRotResist;
            this.UI_childAlphaBaseSec = source.UI_childAlphaBaseSec;
            this.UI_childAlphaDstType = source.UI_childAlphaDstType;
            this.UI_childAlphaSec = source.UI_childAlphaSec;
            this.UI_childBlendType = source.UI_childBlendType;
            this.UI_childColorInheritType = source.UI_childColorInheritType;
            this.UI_childColorType = source.UI_childColorType;
            this.UI_isChildColorScaleInherited = source.UI_isChildColorScaleInherited;
            this.UI_childColorScale = source.UI_childColorScale;
            this.UI_childGravity = source.UI_childGravity;
            this.UI_childLife = source.UI_childLife;
            this.UI_childRotType = source.UI_childRotType;
            this.UI_childScaleSec = source.UI_childScaleSec;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override ChildAssistData Clone()
        {
            return new ChildAssistData(this);
        }

        #endregion
    }
}

