﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_1.Build_0.Revision_0
{
    /// <summary>
    /// アニメーション編集データ
    /// </summary>
    public sealed class TexPatData : BaseDataModel<TexPatData>
    {
        /// <summary>
        /// TexPatTblの配列サイズ
        /// </summary>
        public const int cNumTexPatTbl = 32;

        #region Properties

        /// <summary>
        ///
        /// </summary>
        public TextureAddressing UI_textureAddressing { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatDivX { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatDivY { get; set; }

        /// <summary>
        ///
        /// </summary>
        public TextureWrapMode UI_texWrapU { get; set; }

        /// <summary>
        ///
        /// </summary>
        public TextureWrapMode UI_texWrapV { get; set; }

        /// <summary>
        ///
        /// </summary>
        public uint UI_texPatNumPattern { get; set; }

        /// <summary>
        ///
        /// </summary>
        public FilterMode UI_texFilterMode { get; set; }

        /// <summary>
        ///
        /// </summary>
        public string UI_texPatFileName { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_numUseTexPatTbl { get; set; }

        /// <summary>
        /// This field does not set to the serializer directly, instead,
        /// this field sets the value to UI_texPatAnimType and UI_texPatAnim,
        /// the serializer gets and sets values to these two fields.
        /// 0: No Animation
        /// 1: Live fit
        /// 2: Loop
        /// 3: Random
        /// 4: Clamp
        /// </summary>
        public int UI_texPatAnimMode
        {
            get { return (UI_texPatAnim==0 ? 0 : UI_texPatAnimType + 1); }
            set
            {
                if ( value==0 )
                {
                    UI_texPatAnim = 0;
                }
                else
                {
                    UI_texPatAnim     = 1;
                    UI_texPatAnimType = value - 1;
                }
            }
        }

        /// <summary>
        /// 0: Live fit
        /// 1: Loop
        /// 2: Random
        /// 3: Clamp
        /// </summary>
        public int UI_texPatAnimType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public uint UI_texPatFreqFrame { get; set; }

        /// <summary>
        /// /*cNumTexPatTbl*/
        /// </summary>
        public int[] UI_texPatTbl { get; set; }

        /// <summary>
        /// 0:アニメなし
        /// 1:アニメ有り
        /// </summary>
        public int UI_texPatAnim { get; set; }

        /// <summary>
        /// テクスチャーパターンのランダム
        /// 0:ランダムなし 1:ランダム有り
        /// </summary>
        public bool UI_texPatIsRandom { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public TexPatData()
        {
            this.UI_textureAddressing = TextureAddressing.Normal;
            this.UI_texPatTbl = new int[cNumTexPatTbl];
            this.UI_texPatFileName = string.Empty;
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public TexPatData(TexPatData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.UI_numUseTexPatTbl = 2;
            this.UI_texPatDivX = 1;
            this.UI_texPatDivY = 1;
            this.UI_texPatFreqFrame = 1;
            this.UI_texPatNumPattern = 1;
            this.UI_texPatIsRandom = false;
            this.UI_texPatAnimType = 0;
            this.UI_texPatAnim = 0;
        }

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(TexPatData source)
        {
            Ensure.Argument.NotNull(source);

            this.UI_texPatFileName = source.UI_texPatFileName;
            this.UI_textureAddressing = source.UI_textureAddressing;
            this.UI_texPatDivX = source.UI_texPatDivX;
            this.UI_texPatDivY = source.UI_texPatDivY;
            this.UI_texWrapU = source.UI_texWrapU;
            this.UI_texWrapV = source.UI_texWrapV;
            this.UI_texPatNumPattern = source.UI_texPatNumPattern;
            this.UI_texFilterMode = source.UI_texFilterMode;
            this.UI_texPatAnimType = source.UI_texPatAnimType;
            this.UI_texPatFreqFrame = source.UI_texPatFreqFrame;

            this.UI_numUseTexPatTbl = source.UI_numUseTexPatTbl;
            for (int i = 0; i < cNumTexPatTbl; ++i)
            {
                this.UI_texPatTbl[i] = source.UI_texPatTbl[i];
            }

            this.UI_texPatAnim = source.UI_texPatAnim;
            this.UI_texPatIsRandom = source.UI_texPatIsRandom;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override TexPatData Clone()
        {
            return new TexPatData(this);
        }

        #endregion
    }
}

