﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Diagnostics;
using System.Drawing;
using System.Collections.Generic;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_1.Build_0.Revision_0
{
    /// <summary>
    /// エミッタデータ
    /// </summary>
    public class EmitterData : ComplexEmitterData
    {
        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public EmitterData()
        {
            // EditData
            m_editData = new EditDataEmitter();

            //
            this.UI_initRot = new Vector3i();
            this.UI_initRotRand = new Vector3i();
            this.UI_rotBasis = new Vector2();
            this.UI_rotVel = new Vector3i();
            this.UI_rotVelRand = new Vector3i();
            this.UI_transformRot = new Vector3i();
            this.UI_transformScale = new Vector3();
            this.UI_transformTrans = new Vector3();
            this.UI_hostioEmitterFlg = new EmitterFlag();
            this.EmitterGameData = new EmitterGameData();

            Initialize();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public EmitterData(EmitterData source)
            : this()
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期値の設定
        /// </summary>
        public override void Initialize()
        {
            base.Initialize();

            // EditDataのコピー
            this.EditData.Initialize();

            this.UI_colorType = Constances.ColorCommonType.Modulate;
            this.UI_colorScale = 1.0f;

            this.UI_emitTime = 1;
            this.UI_initRot.Set(0, 0, 0);
            this.UI_initRotRand.Set(0, 0, 0);
            this.UI_isOneTime = false;
            this.UI_rotBasis.Set(0.0f, 0.0f);
            this.UI_rotVel.Set(0, 0, 0);
            this.UI_rotVelRand.Set(0, 0, 0);
            this.UI_transformRot.Set(0, 0, 0);
            this.UI_transformScale.Set(1.0f, 1.0f, 1.0f);
            this.UI_transformTrans.Set(0.0f, 0.0f, 0.0f);

            this.UI_hostioEmitterFlg.Initialize();
            this.EmitterGameData.Initialize();
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// ベクトルを設定します。
        /// </summary>
        /// <param name="source">設定するベクトルです。</param>
        public void Set(EmitterData source)
        {
            Ensure.Argument.NotNull(source);

            // EditDataのコピー
            this.EditData.Set(source.EditData);

            // ComplexEmitterData
            base.Set(source as ComplexEmitterData);

            this.UI_initRot.Set(source.UI_initRot);
            this.UI_initRotRand.Set(source.UI_initRotRand);
            this.UI_rotBasis.Set(source.UI_rotBasis);
            this.UI_rotVel.Set(source.UI_rotVel);
            this.UI_rotVelRand.Set(source.UI_rotVelRand);
            this.UI_transformRot.Set(source.UI_transformRot);
            this.UI_transformScale.Set(source.UI_transformScale);
            this.UI_transformTrans.Set(source.UI_transformTrans);
            this.UI_hostioEmitterFlg.Set(source.UI_hostioEmitterFlg);

            this.UI_initVelRnd = source.UI_initVelRnd;
            this.UI_rotType = source.UI_rotType;
            this.UI_followType = source.UI_followType;
            this.UI_alphaDstType = source.UI_alphaDstType;
            this.UI_scaleRand = source.UI_scaleRand;
            this.UI_fadeAlphaFrameInFade = source.UI_fadeAlphaFrameInFade;
            this.UI_fadeOutType = source.UI_fadeOutType;
            this.UI_colorType = source.UI_colorType;
            this.UI_colorScale = source.UI_colorScale;
            this.UI_emitTime = source.UI_emitTime;
            this.UI_isOneTime = source.UI_isOneTime;
            this.UI_randomSeed = source.UI_randomSeed;
            this.UI_stripeHistoryStep = source.UI_stripeHistoryStep;
            this.UI_Fog = source.UI_Fog;

            this.EmitterGameData.Set(source.EmitterGameData);
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        new public EmitterData Clone()
        {
            return new EmitterData(this);
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であればtrueを返します。</returns>
        public override bool Equals(object other)
        {
            return this.Equals(other as EmitterData);
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であればtrueを返します。</returns>
        public bool Equals(EmitterData source)
        {
            // not supposed to come here
            Debug.Assert(false);
            return true;
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値</returns>
        public override int GetHashCode()
        {
            // not supposed to come here
            Debug.Assert(false);
            return -1;
        }

        #endregion

        #region Properties - EditData

        EditDataEmitter m_editData;
        /// <summary>
        /// 編集用のデータ保存用
        /// （バイナリーには影響を与えない保存用データ）
        /// </summary>
        public EditDataEmitter EditData
        {
            get { return m_editData; }
        }

        #endregion

        #region Properties - EmitterData

        /// <summary>
        ///
        /// </summary>
        public Vector3 UI_transformTrans { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_transformRot { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3 UI_transformScale { get; set; }

        /// <summary>
        ///
        /// </summary>
        public PtclRotType UI_rotType { get; set; }

        /// <summary>
        /// カラー共通タイプ
        /// </summary>
        public Constances.ColorCommonType UI_colorType { get; set; }

        /// <summary>
        /// カラースケール
        /// </summary>
        public float UI_colorScale { get; set; }

        /// <summary>
        ///
        /// </summary>
        public FollowType UI_followType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_scaleRand { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_initVelRnd { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_initRot { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_initRotRand { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_rotVel { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_rotVelRand { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2 UI_rotBasis { get; set; }

        /// <summary>
        ///
        /// </summary>
        public AlphaDst UI_alphaDstType { get; set; }

        /// <summary>
        /// HostIO編集用のデバッグフラグ
        /// </summary>
        public EmitterFlag UI_hostioEmitterFlg { get; set; }

        /// <summary>
        ///
        /// </summary>
        public bool UI_isOneTime { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_emitTime { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_randomSeed { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_stripeHistoryStep { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_Fog { get; set; }

        /// <summary>
        ///
        /// </summary>
        public FadeOutType UI_fadeOutType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_fadeAlphaFrameInFade { get; set; }


        /// <summary>
        /// エミッタ用ゲーム設定データ
        /// </summary>
        public EmitterGameData EmitterGameData { get; set; }

        #endregion
    }
}
