﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    /// <summary>
    /// Field mask
    /// </summary>
    public class EmitterFlag : ISettable, IInitializable
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EmitterFlag()
        {
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public void Initialize()
        {
        }

        /// <summary>
        /// Get or set the flags.
        /// </summary>
        public uint Flag
        {
            get
            {
                uint ret = 0;

                if (ColorRandom == true)
                    ret |= (1 << 0);
                if (DispEmitterMtx == true)
                    ret |= (1 << 1);
                if (DispVolume == true)
                    ret |= (1 << 2);
                if (DispFieldMagnet == true)
                    ret |= (1 << 3);
                if (DispFieldSpin == true)
                    ret |= (1 << 4);
                if (DispFieldCollision == true)
                    ret |= (1 << 5);
                if (DispFieldConvergence == true)
                    ret |= (1 << 6);
                if (EnableFog == true)
                    ret |= (1 << 7);
                if (EnableSoftEdge == true)
                    ret |= (1 << 8);
                if (EnableSortParticle == true)
                    ret |= (1 << 9);
                if (ReverseOrderParticle == true)
                    ret |= (1 << 10);

                return ret;
            }
            set
            {
                ColorRandom = (0 != (value & (1 << 0)));
                DispEmitterMtx = (0 != (value & (1 << 1)));
                DispVolume = (0 != (value & (1 << 2)));
                DispFieldMagnet = (0 != (value & (1 << 3)));
                DispFieldSpin = (0 != (value & (1 << 4)));
                DispFieldCollision = (0 != (value & (1 << 5)));
                DispFieldConvergence = (0 != (value & (1 << 6)));
                EnableFog = (0 != (value & (1 << 7)));
                EnableSoftEdge = (0 != (value & (1 << 8)));
                EnableSortParticle = (0 != (value & (1 << 9)));
                ReverseOrderParticle = (0 != (value & (1 << 10)));
            }
        }

        /// <summary>
        /// ISettable用
        /// </summaey>
        public void Set(object source)
        {
            Ensure.Argument.True(source is EmitterFlag);
            this.Flag = (source as EmitterFlag).Flag;
        }

        /// <summary>
        /// ランダムを使用するか？
        /// </summary>
        public bool ColorRandom { get; set; }

        /// <summary>
        /// 磁力を使用するか？
        /// </summary>
        public bool DispEmitterMtx { get; set; }

        /// <summary>
        /// スピンを使用するか？
        /// </summary>
        public bool DispVolume { get; set; }

        /// <summary>
        /// 収束を使用するか？
        /// </summary>
        public bool DispFieldMagnet { get; set; }

        /// <summary>
        /// 位置に加算を使用するか？
        /// </summary>
        public bool DispFieldSpin { get; set; }

        /// <summary>
        /// コリジョンを使用するか？
        /// </summary>
        public bool DispFieldCollision { get; set; }

        /// <summary>
        /// FieldConvergenceを使用するか？
        /// </summary>
        public bool DispFieldConvergence { get; set; }

        /// <summary>
        /// Fogを使用するか？
        /// </summary>
        public bool EnableFog { get; set; }

        /// <summary>
        /// SoftEdgeを使用するか？
        /// </summary>
        public bool EnableSoftEdge { get; set; }

        /// <summary>
        /// SortParticleを使用するか？
        /// </summary>
        public bool EnableSortParticle { get; set; }

        /// <summary>
        /// ReverseOrderParticleを使用するか？
        /// </summary>
        public bool ReverseOrderParticle{ get; set; }

        /// <summary>
        /// コリジョンを使用するか？
        /// </summary>
        public bool DispFieldMask
        {
            get
            {
                return (DispFieldMagnet ||
                        DispFieldSpin ||
                        DispFieldCollision ||
                        DispFieldConvergence);
            }
        }

        /// <summary>
        /// 全部を使用するか？
        /// </summary>
        public bool All
        {
            get
            {
                return ColorRandom &&
                       DispEmitterMtx &&
                       DispVolume &&
                       DispFieldMagnet &&
                       DispFieldSpin &&
                       DispFieldCollision &&
                       DispFieldConvergence &&
                       EnableFog;
            }
        }
    }
}
