﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    public abstract class BaseDataModelData
    {
        protected static float s_WorldScaleRange = 100.0f;
        protected static int s_WorldScaleTime = 1000;
    };

    /// <summary>
    /// データモデルの基底クラス
    /// </summary>
    public abstract class BaseDataModel<modelT>
        : BaseDataModelData, ICloneable, ISettable, IInitializable
    {
        static readonly Type[] s_typeTbl = new Type[] { typeof(ISettable) };

        #region Utility
#if false // 未対応
        /// <summary>
        /// 全てのプロパティをコピーします。
        /// （配列プロパティ以外をコピーします）
        /// </summary>
        public void CopyProperties(object source)
        {
            Ensure.Argument.True(this is modelT);
            Ensure.Argument.True(this.GetType().Equals(source.GetType()));

            var properties = this.GetType().GetProperties();
            foreach (var property in properties)
            {
                if (property.CanRead && property.CanWrite)
                {
                    var srcProperty = source.GetType().GetProperty(property.Name);
                    Ensure.Argument.NotNull(srcProperty);

                    if (property.PropertyType.IsArray)
                    {
                        // 配列時のコピー
#if false
                        var newValues =
                            srcProperty.GetValue(source, null) as System.Collections.IEnumerable;
                        int index = 0;
                        foreach (var newValue in newValues)
                        {
                            if (property.PropertyType.HasInterface(typeof(ISettable)))
                            {
                                // Set() によるコピー
                                var method =
                                    property.PropertyType.GetMethod("Set", s_typeTbl);
                                Ensure.Argument.NotNull(method != null);
                                method.Invoke(property.GetValue(
                                    this, new object[]{index}), new object[] { newValue });
                            }
                            else
                            {
                                // 通常のプロパティコピー
                                property.SetValue(this, newValue, new object[] { index });
                            }
                            index++;
                        }
#endif
                    }
                    else
                    {
                        object newValue = srcProperty.GetValue(source, null);
                        if (property.PropertyType.HasInterface(typeof(ISettable)))
                        {
                            // Set() によるコピー
                            var method =
                                property.PropertyType.GetMethod("Set", s_typeTbl);
                            Ensure.Argument.NotNull(method != null);
                            method.Invoke(property.GetValue(this, null), new object[] { newValue });
                        }
                        else
                        {
                            // 通常のプロパティコピー
                            property.SetValue(this, newValue, null);
                        }
                    }
                }
            }
        }
#endif
        #endregion

        #region abstract Functions

        /// <summary>
        /// クローン
        /// </summary>
        object ICloneable.Clone()
        {
            return this.Clone();
        }

        /// <summary>
        /// クローン
        /// </summary>
        public abstract modelT Clone();

        /// <summary>
        /// オブジェクト設定
        /// </summary>
        void ISettable.Set(object source)
        {
            Ensure.Argument.True(source is modelT);
            this.Set((modelT)source);
        }

        /// <summary>
        /// オブジェクト設定
        /// </summary>
        public abstract void Set(modelT source);

        /// <summary>
        /// 初期化
        /// </summary>
        public abstract void Initialize();

        #endregion
    }
}
