﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Text;
using System.Runtime.InteropServices;

namespace App.Win32
{
    #region User32

    /// <summary>
    /// user32.dll。
    /// </summary>
    public sealed class User32
    {
        // WinUser.h

        /// <summary>
        /// インポート関数：AdjustWindowRect
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool AdjustWindowRect(ref RECT lpRect, int dwStyle, bool bMenu);

        /// <summary>
        /// インポート関数：AdjustWindowRectEx
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool AdjustWindowRectEx(ref RECT lpRect, int dwStyle, bool bMenu, int dwExStyle);

        /// <summary>
        /// インポート関数：BeginPaint
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr BeginPaint(IntPtr hWnd, ref PAINTSTRUCT lpPaint);

        /// <summary>
        /// インポート関数：DrawFocusRect
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool DrawFocusRect(IntPtr hDC, ref RECT lprc);

        /// <summary>
        /// インポート関数：EndPaint
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool EndPaint(IntPtr hWnd, ref PAINTSTRUCT lpPaint);

        /// <summary>
        /// インポート関数：GetClientRect
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool GetClientRect(IntPtr hWnd, ref RECT lpRect);

        /// <summary>
        /// インポート関数：GetUpdateRect
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool GetUpdateRect(IntPtr hWnd, ref RECT lpRect, bool bErase);

        /// <summary>
        /// インポート関数：GetWindowDC
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr GetWindowDC(IntPtr hWnd);

        /// <summary>
        /// インポート関数：GetWindowLong
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int GetWindowLong(IntPtr hWnd, int nIndex);

        /// <summary>
        /// インポート関数：SetWindowLong
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int SetWindowLong(IntPtr hWnd, int nIndex, int dwNewLong);

        /// <summary>
        /// インポート関数：GetWindowPlacement
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool GetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        /// <summary>
        /// インポート関数：SetWindowPlacement
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool SetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        /// <summary>
        /// インポート関数：GetWindowRect
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool GetWindowRect(IntPtr hWnd, ref RECT lpRect);

        /// <summary>
        /// インポート関数：MessageBox
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int MessageBox(IntPtr hWnd, string lpText, string lpCaption, int uType);

        /// <summary>
        /// インポート関数：RedrawWindow
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool RedrawWindow(IntPtr hWnd, ref RECT lprcUpdate, IntPtr hrgnUpdate, int flags);

        /// <summary>
        /// インポート関数：ReleaseDC
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int ReleaseDC(IntPtr hWnd, IntPtr hDC);

        /// <summary>
        /// インポート関数：SendMessage
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, IntPtr lParam);

        /// <summary>
        /// インポート関数：SendMessage
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, ref RECT lParam);

        /// <summary>
        /// インポート関数：SendMessage
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, int[] lParam);

        /// <summary>
        /// インポート関数：SendMessage
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, ref HDITEM lParam);

        /// <summary>
        /// インポート関数：SendMessage
        /// </summary>
        [DllImport("user32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, ref TVHITTESTINFO lParam);
    }
    #endregion

    #region Gdi32
    /// <summary>
    /// gdi32.dll。
    /// </summary>
    public sealed class Gdi32
    {
        // WinGDI.h

        /// <summary>
        /// インポート関数：BitBlt
        /// </summary>
        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool BitBlt(IntPtr hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, IntPtr hdcSrc, int nXSrc, int nYSrc, int dwRop);

        /// <summary>
        /// インポート関数：CombineRgn
        /// </summary>
        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int CombineRgn(IntPtr hrgnDst, IntPtr hrgnSrc1, IntPtr hrgnSrc2, int fnCombineMode);

        /// <summary>
        /// インポート関数：CreateRectRgn
        /// </summary>
        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr CreateRectRgn(int x1, int y1, int x2, int y2);

        /// <summary>
        /// インポート関数：DeleteObject
        /// </summary>
        [DllImport("gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool DeleteObject(IntPtr hObject);
    }
    #endregion

    #region Shell32
    /// <summary>
    /// shell32.dll。
    /// </summary>
    public static class Shell32
    {
        /// <summary>
        /// インポート関数：FindExecutable
        /// </summary>
        [DllImport("shell32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int FindExecutable(string lpFile, string lpDirectory, StringBuilder lpResult);

        /// <summary>
        /// インポート関数：SHGetFileInfo
        /// </summary>
        [DllImport("shell32.dll")]
        public static extern IntPtr SHGetFileInfo( string pszPath,
                                                   uint dwFileAttributes,
                                                   ref SHFILEINFO psfi,
                                                   uint cbSizeFileInfo,
                                                   uint uFlags );

        /// <summary>
        /// インポート関数：ExtractIconEx
        /// </summary>
        [DllImport( "shell32.dll", CharSet=CharSet.Auto, SetLastError=true )]
        public static extern uint ExtractIconEx( string pszPath,
                                                 int iIconIndex,
                                                 ref IntPtr hLargeIcon,
                                                 ref IntPtr hSmallIcon,
                                                 int iIcons );

        /// <summary>
        /// インポート関数：DestroyIcon
        /// </summary>
        [DllImport("shell32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool DestroyIcon( IntPtr hIcon );
    }
    #endregion
}
