﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using NintendoWare.ToolDevelopmentKit;

namespace App.Utility

{
    /// <summary>
    /// ポイントユーティリティクラス。
    /// </summary>
    public static class PointUtility
    {
        /// <summary>
        /// ２点間の距離を取得。
        /// </summary>
        public static float GetDistance(PointF pt1, PointF pt2)
        {
            return (float)Math.Sqrt(
                (pt2.X - pt1.X) * (pt2.X - pt1.X) + (pt2.Y - pt1.Y) * (pt2.Y - pt1.Y));
        }

        /// <summary>
        /// POINT型に変換。
        /// </summary>
        public static Win32.POINT ToPOINT(Point pt)
        {
            Win32.POINT result = new Win32.POINT();
            result.x = pt.X;
            result.y = pt.Y;
            return result;
        }
    }
}
