﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace App.Utility
{
    /// <summary>
    /// Represent a scoped disposable that delegates exeuction to lambda expressions
    /// </summary>
    public class AnonymousDisposable : IDisposable
    {
        private bool isDisposed;
        private readonly Action onDisposed;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="ctor">Anonymous method executed in the constructor</param>
        /// <param name="onDisposed">Anonymous method executed when
        /// the AnonymousDisposable is disposed</param>
        public AnonymousDisposable(Action ctor, Action onDisposed)
            : this(onDisposed)
        {
            if (ctor == null)
                throw new ArgumentNullException("ctor");

            ctor();
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="onDisposed">Anonymous method executed when
        /// the AnonymousDisposable is disposed</param>
        public AnonymousDisposable(Action onDisposed)
        {
            if (onDisposed == null)
                throw new ArgumentNullException("onDisposed");

            this.onDisposed = onDisposed;
        }


        /// <summary>
        /// Dispose
        /// </summary>
        public void Dispose()
        {
            if (isDisposed)
                return;

            isDisposed = true;
            onDisposed();
        }
    }
}
