﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace App
{
    /// <summary>
    /// メニューコマンドＩＤ。
    /// </summary>
    public enum MenuCommandID
    {
        /// <summary></summary>
        FileNewProject,
        /// <summary></summary>
        FileNewEmitterSet,
        /// <summary></summary>
        FileNewEmitter,
        /// <summary></summary>
        FileNewPreview,
        /// <summary></summary>
        FileOpen,
        /// <summary></summary>
        FileRecentFilesRoot,
        /// <summary></summary>
        FileRecentFilesItem,
        /// <summary></summary>
        FileRecentFilesClear,
        /// <summary></summary>
        TemplateOpen,

        /// <summary></summary>
        FileEnvLoad,
        /// <summary></summary>
        FileEnvSave,
        /// <summary></summary>
        FileEnvSaveAs,

        /// <summary></summary>
        FileClose,
        /// <summary></summary>
        FileCloseModelSet,
        /// <summary></summary>
        FileCloseAll,
        /// <summary></summary>
        FileCloseSelection,
        /// <summary></summary>
        FileSave,
        /// <summary></summary>
        FileSaveAs,
        /// <summary></summary>
        FileSaveAll,
        /// <summary></summary>
        FileSaveAllTo,
        /// <summary></summary>
        FileSaveBinary,
        /// <summary></summary>
        FileRename,
        /// <summary></summary>
        FileExit,
        /// <summary></summary>
        EditUndo,
        /// <summary></summary>
        EditRedo,

        /// <summary></summary>
        ViewProperty,
        /// <summary>Effect browser</summary>
        ViewEffectBrowser,
        /// <summary></summary>
        ViewHistory,
        /// <summary></summary>
        ViewToolBar,
        /// <summary></summary>
        ViewStatusBar,

        /// <summary></summary>
        PreviewChangeConnection,
        /// <summary></summary>
        SendBinaryAgain,

        /// <summary></summary>
        ToolOption,
        /// <summary></summary>
        HelpHelp,
        /// <summary></summary>
        HelpViewer,
        /// <summary></summary>
        HelpOverview,
        /// <summary></summary>
        HelpGlossary,
        /// <summary></summary>
        HelpTips,
        /// <summary></summary>
        HelpAbout,

        /// <summary></summary>
        DebugDefSetup,
        /// <summary></summary>
        DebugGoto,
        /// <summary></summary>
        DebugChez,
        /// <summary></summary>
        DebugTanaka,
        /// <summary></summary>
        DebugIshibashi,
    }
}
